/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopedIndexFieldComponent;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopedIndexRootComponent;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchBooleanPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchExistsPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchAllPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchIdPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchNestedPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateCollector;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSimpleQueryStringPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchUserProvidedJsonPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchSearchPredicateBuilderFactoryImpl
implements ElasticsearchSearchPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final PredicateBuilderFactoryRetrievalStrategy PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new PredicateBuilderFactoryRetrievalStrategy();
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchScopeModel scopeModel;

    public ElasticsearchSearchPredicateBuilderFactoryImpl(ElasticsearchSearchContext searchContext, ElasticsearchScopeModel scopeModel) {
        this.searchContext = searchContext;
        this.scopeModel = scopeModel;
    }

    public SearchPredicate toSearchPredicate(ElasticsearchSearchPredicateBuilder builder) {
        return new ElasticsearchSearchPredicate(builder, this.scopeModel.getHibernateSearchIndexNames());
    }

    public ElasticsearchSearchPredicateBuilder toImplementation(SearchPredicate predicate) {
        if (!(predicate instanceof ElasticsearchSearchPredicate)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherPredicates(predicate);
        }
        ElasticsearchSearchPredicate casted = (ElasticsearchSearchPredicate)predicate;
        if (!this.scopeModel.getHibernateSearchIndexNames().equals(casted.getIndexNames())) {
            throw log.predicateDefinedOnDifferentIndexes(predicate, casted.getIndexNames(), this.scopeModel.getHibernateSearchIndexNames());
        }
        return casted;
    }

    public void contribute(ElasticsearchSearchPredicateCollector collector, ElasticsearchSearchPredicateBuilder builder) {
        collector.collectPredicate(builder.build(collector.getRootPredicateContext()));
    }

    public MatchAllPredicateBuilder<ElasticsearchSearchPredicateBuilder> matchAll() {
        return new ElasticsearchMatchAllPredicateBuilder();
    }

    public MatchIdPredicateBuilder<ElasticsearchSearchPredicateBuilder> id() {
        ElasticsearchScopedIndexRootComponent<ToDocumentIdentifierValueConverter<?>> component = this.scopeModel.getIdDslConverter();
        return new ElasticsearchMatchIdPredicateBuilder(this.searchContext, component.getIdConverterCompatibilityChecker(), component.getComponent());
    }

    public BooleanPredicateBuilder<ElasticsearchSearchPredicateBuilder> bool() {
        return new ElasticsearchBooleanPredicateBuilder();
    }

    public MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> match(String absoluteFieldPath) {
        ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        return fieldComponent.getComponent().createMatchPredicateBuilder(this.searchContext, absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath), fieldComponent.getConverterCompatibilityChecker(), fieldComponent.getAnalyzerCompatibilityChecker());
    }

    public RangePredicateBuilder<ElasticsearchSearchPredicateBuilder> range(String absoluteFieldPath) {
        ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        return fieldComponent.getComponent().createRangePredicateBuilder(this.searchContext, absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath), fieldComponent.getConverterCompatibilityChecker());
    }

    public PhrasePredicateBuilder<ElasticsearchSearchPredicateBuilder> phrase(String absoluteFieldPath) {
        ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        return fieldComponent.getComponent().createPhrasePredicateBuilder(absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath), fieldComponent.getAnalyzerCompatibilityChecker());
    }

    public WildcardPredicateBuilder<ElasticsearchSearchPredicateBuilder> wildcard(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createWildcardPredicateBuilder(absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath));
    }

    public SimpleQueryStringPredicateBuilder<ElasticsearchSearchPredicateBuilder> simpleQueryString() {
        return new ElasticsearchSimpleQueryStringPredicateBuilder(this.scopeModel);
    }

    public ExistsPredicateBuilder<ElasticsearchSearchPredicateBuilder> exists(String absoluteFieldPath) {
        List<String> nestedPathHierarchy;
        if (this.scopeModel.hasSchemaObjectNodeComponent(absoluteFieldPath)) {
            nestedPathHierarchy = this.scopeModel.getNestedPathHierarchyForObject(absoluteFieldPath);
        } else {
            nestedPathHierarchy = this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath);
            this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        }
        return new ElasticsearchExistsPredicateBuilder(absoluteFieldPath, nestedPathHierarchy);
    }

    public SpatialWithinCirclePredicateBuilder<ElasticsearchSearchPredicateBuilder> spatialWithinCircle(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createSpatialWithinCirclePredicateBuilder(absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath));
    }

    public SpatialWithinPolygonPredicateBuilder<ElasticsearchSearchPredicateBuilder> spatialWithinPolygon(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createSpatialWithinPolygonPredicateBuilder(absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath));
    }

    public SpatialWithinBoundingBoxPredicateBuilder<ElasticsearchSearchPredicateBuilder> spatialWithinBoundingBox(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createSpatialWithinBoundingBoxPredicateBuilder(absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath));
    }

    public NestedPredicateBuilder<ElasticsearchSearchPredicateBuilder> nested(String absoluteFieldPath) {
        this.scopeModel.checkNestedField(absoluteFieldPath);
        List<String> nestedPathHierarchy = this.scopeModel.getNestedPathHierarchyForObject(absoluteFieldPath);
        return new ElasticsearchNestedPredicateBuilder(absoluteFieldPath, nestedPathHierarchy);
    }

    @Override
    public ElasticsearchSearchPredicateBuilder fromJson(JsonObject jsonObject) {
        return new ElasticsearchUserProvidedJsonPredicateBuilder(jsonObject);
    }

    @Override
    public ElasticsearchSearchPredicateBuilder fromJson(String jsonString) {
        return this.fromJson((JsonObject)this.searchContext.getUserFacingGson().fromJson(jsonString, JsonObject.class));
    }

    private static class PredicateBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<ElasticsearchFieldPredicateBuilderFactory> {
        private PredicateBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public ElasticsearchFieldPredicateBuilderFactory extractComponent(ElasticsearchIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.type().getPredicateBuilderFactory();
        }

        @Override
        public boolean hasCompatibleCodec(ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2) {
            return component1.hasCompatibleCodec(component2);
        }

        @Override
        public boolean hasCompatibleConverter(ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2) {
            return component1.hasCompatibleConverter(component2);
        }

        @Override
        public boolean hasCompatibleAnalyzer(ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2) {
            return component1.hasCompatibleAnalyzer(component2);
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForPredicate(absoluteFieldPath, component1, component2, context);
        }
    }
}

