/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchRequestTransformer;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchRequestTransformerContextImpl;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExplainResult;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.engine.search.query.spi.AbstractSearchQuery;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSearchQueryImpl<H>
extends AbstractSearchQuery<H, ElasticsearchSearchResult<H>>
implements ElasticsearchSearchQuery<H> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final int MAX_RESULT_WINDOW_SIZE = 10000;
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchParallelWorkOrchestrator queryOrchestrator;
    private final ElasticsearchSearchContext searchContext;
    private final BackendSessionContext sessionContext;
    private final LoadingContext<?, ?> loadingContext;
    private final Set<String> routingKeys;
    private final JsonObject payload;
    private final ElasticsearchSearchRequestTransformer requestTransformer;
    private final ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor;
    private Long timeoutValue;
    private TimeUnit timeoutUnit;
    private boolean exceptionOnTimeout;

    ElasticsearchSearchQueryImpl(ElasticsearchWorkBuilderFactory workFactory, ElasticsearchParallelWorkOrchestrator queryOrchestrator, ElasticsearchSearchContext searchContext, BackendSessionContext sessionContext, LoadingContext<?, ?> loadingContext, Set<String> routingKeys, JsonObject payload, ElasticsearchSearchRequestTransformer requestTransformer, ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor, Long timeoutValue, TimeUnit timeoutUnit, boolean exceptionOnTimeout) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.routingKeys = routingKeys;
        this.payload = payload;
        this.requestTransformer = requestTransformer;
        this.searchResultExtractor = searchResultExtractor;
        this.timeoutValue = timeoutValue;
        this.timeoutUnit = timeoutUnit;
        this.exceptionOnTimeout = exceptionOnTimeout;
    }

    public String getQueryString() {
        return this.payload.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getQueryString() + "]";
    }

    public <Q> Q extension(SearchQueryExtension<Q, H> extension) {
        return (Q)DslExtensionState.returnIfSupported(extension, (Optional)extension.extendOptional((SearchQuery)this, this.loadingContext));
    }

    public ElasticsearchSearchResult<H> fetch(Integer offset, Integer limit) {
        NonBulkableWork work = (NonBulkableWork)this.workFactory.search(this.payload, this.searchResultExtractor).indexes(this.searchContext.getElasticsearchIndexNames()).paging(this.defaultedLimit(limit, offset), offset).routingKeys(this.routingKeys).timeout(this.timeoutValue, this.timeoutUnit, this.exceptionOnTimeout).requestTransformer(ElasticsearchSearchRequestTransformerContextImpl.createTransformerFunction(this.requestTransformer)).build();
        return ((ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work))).loadBlocking();
    }

    public long fetchTotalHitCount() {
        JsonObject filteredPayload = new JsonObject();
        Optional querySubTree = JsonAccessor.root().property("query").asObject().get(this.payload);
        if (querySubTree.isPresent()) {
            filteredPayload.add("query", (JsonElement)querySubTree.get());
        }
        NonBulkableWork work = (NonBulkableWork)this.workFactory.count(this.searchContext.getElasticsearchIndexNames()).query(filteredPayload).routingKeys(this.routingKeys).timeout(this.timeoutValue, this.timeoutUnit, this.exceptionOnTimeout).requestTransformer(ElasticsearchSearchRequestTransformerContextImpl.createTransformerFunction(this.requestTransformer)).build();
        return (Long)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work));
    }

    @Override
    public JsonObject explain(String id) {
        Contracts.assertNotNull((Object)id, (String)"id");
        Collection<URLEncodedString> targetedIndexNames = this.searchContext.getElasticsearchIndexNames();
        if (targetedIndexNames.size() != 1) {
            throw log.explainRequiresIndexName(this.searchContext.getHibernateSearchIndexNames());
        }
        return this.doExplain(targetedIndexNames.iterator().next(), id);
    }

    @Override
    public JsonObject explain(String typeName, String id) {
        Contracts.assertNotNull((Object)typeName, (String)"typeName");
        Contracts.assertNotNull((Object)id, (String)"id");
        Map<String, URLEncodedString> mappedTypeNamesToIndexReadNames = this.searchContext.getMappedTypeToElasticsearchIndexNames();
        if (!mappedTypeNamesToIndexReadNames.containsKey(typeName)) {
            throw log.explainRequiresTypeTargetedByQuery(mappedTypeNamesToIndexReadNames.keySet(), typeName);
        }
        return this.doExplain(mappedTypeNamesToIndexReadNames.get(typeName), id);
    }

    private Integer defaultedLimit(Integer limit, Integer offset) {
        if (limit != null) {
            return limit;
        }
        int maxLimitThatElasticsearchWillAccept = 10000;
        if (offset != null) {
            maxLimitThatElasticsearchWillAccept -= offset.intValue();
        }
        return maxLimitThatElasticsearchWillAccept;
    }

    private JsonObject doExplain(URLEncodedString encodedIndexName, String id) {
        URLEncodedString elasticsearchId = URLEncodedString.fromString(this.searchContext.toElasticsearchId(this.sessionContext.getTenantIdentifier(), id));
        JsonObject queryOnlyPayload = new JsonObject();
        JsonElement query = this.payload.get("query");
        if (query != null) {
            queryOnlyPayload.add("query", query);
        }
        NonBulkableWork work = (NonBulkableWork)this.workFactory.explain(encodedIndexName, elasticsearchId, queryOnlyPayload).routingKeys(this.routingKeys).requestTransformer(ElasticsearchSearchRequestTransformerContextImpl.createTransformerFunction(this.requestTransformer)).build();
        ExplainResult explainResult = (ExplainResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work));
        return explainResult.getJsonObject();
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutValue = timeout;
        this.timeoutUnit = timeUnit;
        this.exceptionOnTimeout = true;
    }
}

