/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopedIndexFieldComponent;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchIndexOrderSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchScoreSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchUserProvidedJsonSortBuilder;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.engine.search.sort.spi.ScoreSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchSearchSortBuilderFactoryImpl
implements ElasticsearchSearchSortBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final SortBuilderFactoryRetrievalStrategy SORT_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new SortBuilderFactoryRetrievalStrategy();
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchScopeModel scopeModel;

    public ElasticsearchSearchSortBuilderFactoryImpl(ElasticsearchSearchContext searchContext, ElasticsearchScopeModel scopeModel) {
        this.searchContext = searchContext;
        this.scopeModel = scopeModel;
    }

    public SearchSort toSearchSort(List<ElasticsearchSearchSortBuilder> builders) {
        return new ElasticsearchSearchSort(builders, this.scopeModel.getHibernateSearchIndexNames());
    }

    public ElasticsearchSearchSortBuilder toImplementation(SearchSort sort) {
        if (!(sort instanceof ElasticsearchSearchSort)) {
            throw log.cannotMixElasticsearchSearchSortWithOtherSorts(sort);
        }
        ElasticsearchSearchSort casted = (ElasticsearchSearchSort)sort;
        if (!this.scopeModel.getHibernateSearchIndexNames().equals(casted.getIndexNames())) {
            throw log.sortDefinedOnDifferentIndexes(sort, casted.getIndexNames(), this.scopeModel.getHibernateSearchIndexNames());
        }
        return casted;
    }

    public void contribute(ElasticsearchSearchSortCollector collector, ElasticsearchSearchSortBuilder builder) {
        builder.buildAndAddTo(collector);
    }

    public ScoreSortBuilder<ElasticsearchSearchSortBuilder> score() {
        return new ElasticsearchScoreSortBuilder();
    }

    public FieldSortBuilder<ElasticsearchSearchSortBuilder> field(String absoluteFieldPath) {
        ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldSortBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, SORT_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        return fieldComponent.getComponent().createFieldSortBuilder(this.searchContext, absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath), fieldComponent.getConverterCompatibilityChecker());
    }

    public DistanceSortBuilder<ElasticsearchSearchSortBuilder> distance(String absoluteFieldPath, GeoPoint location) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, SORT_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createDistanceSortBuilder(this.searchContext, absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath), location);
    }

    public ElasticsearchSearchSortBuilder indexOrder() {
        return ElasticsearchIndexOrderSortBuilder.INSTANCE;
    }

    @Override
    public ElasticsearchSearchSortBuilder fromJson(JsonObject jsonObject) {
        return new ElasticsearchUserProvidedJsonSortBuilder(jsonObject);
    }

    @Override
    public ElasticsearchSearchSortBuilder fromJson(String jsonString) {
        return this.fromJson((JsonObject)this.searchContext.getUserFacingGson().fromJson(jsonString, JsonObject.class));
    }

    private static class SortBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<ElasticsearchFieldSortBuilderFactory> {
        private SortBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public ElasticsearchFieldSortBuilderFactory extractComponent(ElasticsearchIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.type().getSortBuilderFactory();
        }

        @Override
        public boolean hasCompatibleCodec(ElasticsearchFieldSortBuilderFactory component1, ElasticsearchFieldSortBuilderFactory component2) {
            return component1.hasCompatibleCodec(component2);
        }

        @Override
        public boolean hasCompatibleConverter(ElasticsearchFieldSortBuilderFactory component1, ElasticsearchFieldSortBuilderFactory component2) {
            return component1.hasCompatibleConverter(component2);
        }

        @Override
        public boolean hasCompatibleAnalyzer(ElasticsearchFieldSortBuilderFactory component1, ElasticsearchFieldSortBuilderFactory component2) {
            return true;
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, ElasticsearchFieldSortBuilderFactory component1, ElasticsearchFieldSortBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForSort(absoluteFieldPath, component1, component2, context);
        }
    }
}

