/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.aggregation.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractElasticsearchFieldAggregationBuilderFactory<F>
implements ElasticsearchFieldAggregationBuilderFactory {
    protected static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final boolean aggregable;
    protected final DslConverter<?, ? extends F> toFieldValueConverter;
    protected final ProjectionConverter<? super F, ?> fromFieldValueConverter;
    protected final ElasticsearchFieldCodec<F> codec;

    public AbstractElasticsearchFieldAggregationBuilderFactory(boolean aggregable, DslConverter<?, ? extends F> toFieldValueConverter, ProjectionConverter<? super F, ?> fromFieldValueConverter, ElasticsearchFieldCodec<F> codec) {
        this.aggregable = aggregable;
        this.toFieldValueConverter = toFieldValueConverter;
        this.fromFieldValueConverter = fromFieldValueConverter;
        this.codec = codec;
    }

    @Override
    public boolean isAggregable() {
        return this.aggregable;
    }

    @Override
    public boolean hasCompatibleCodec(ElasticsearchFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractElasticsearchFieldAggregationBuilderFactory castedOther = (AbstractElasticsearchFieldAggregationBuilderFactory)other;
        return this.aggregable == castedOther.aggregable && this.codec.isCompatibleWith(castedOther.codec);
    }

    @Override
    public boolean hasCompatibleConverter(ElasticsearchFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractElasticsearchFieldAggregationBuilderFactory castedOther = (AbstractElasticsearchFieldAggregationBuilderFactory)other;
        return this.toFieldValueConverter.isCompatibleWith(castedOther.toFieldValueConverter) && this.fromFieldValueConverter.isCompatibleWith(castedOther.fromFieldValueConverter);
    }

    protected static void checkAggregable(String absoluteFieldPath, boolean aggregable) {
        if (!aggregable) {
            throw log.nonAggregableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }
}

