/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.aggregation.impl;

import java.util.List;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchRangeAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchTermsAggregation;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.AbstractElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;

public class ElasticsearchStandardFieldAggregationBuilderFactory<F>
extends AbstractElasticsearchFieldAggregationBuilderFactory<F> {
    private final DslConverter<? super F, ? extends F> rawToFieldValueConverter;
    private final ProjectionConverter<? super F, F> rawFromFieldValueConverter;

    public ElasticsearchStandardFieldAggregationBuilderFactory(boolean aggregable, DslConverter<?, ? extends F> toFieldValueConverter, DslConverter<? super F, ? extends F> rawToFieldValueConverter, ProjectionConverter<? super F, ?> fromFieldValueConverter, ProjectionConverter<? super F, F> rawFromFieldValueConverter, ElasticsearchFieldCodec<F> codec) {
        super(aggregable, toFieldValueConverter, fromFieldValueConverter, codec);
        this.rawToFieldValueConverter = rawToFieldValueConverter;
        this.rawFromFieldValueConverter = rawFromFieldValueConverter;
    }

    @Override
    public <K> TermsAggregationBuilder<K> createTermsAggregationBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, Class<K> expectedType, ValueConvert convert) {
        ElasticsearchStandardFieldAggregationBuilderFactory.checkAggregable(absoluteFieldPath, this.aggregable);
        ProjectionConverter<F, K> fromFieldValueConverter = this.getFromFieldValueConverter(absoluteFieldPath, expectedType, convert);
        return new ElasticsearchTermsAggregation.Builder<F, K>(searchContext, absoluteFieldPath, nestedPathHierarchy, fromFieldValueConverter, this.codec);
    }

    @Override
    public <K> RangeAggregationBuilder<K> createRangeAggregationBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, Class<K> expectedType, ValueConvert convert) {
        ElasticsearchStandardFieldAggregationBuilderFactory.checkAggregable(absoluteFieldPath, this.aggregable);
        DslConverter<?, F> toFieldValueConverter = this.getToFieldValueConverter(absoluteFieldPath, expectedType, convert);
        return new ElasticsearchRangeAggregation.Builder(searchContext, absoluteFieldPath, nestedPathHierarchy, toFieldValueConverter, this.codec);
    }

    private <T> DslConverter<?, ? extends F> getToFieldValueConverter(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        DslConverter result;
        switch (convert) {
            case NO: {
                result = this.rawToFieldValueConverter;
                break;
            }
            default: {
                result = this.toFieldValueConverter;
            }
        }
        if (!result.isValidInputType(expectedType)) {
            throw log.invalidAggregationInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return result;
    }

    private <T> ProjectionConverter<? super F, ? extends T> getFromFieldValueConverter(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        ProjectionConverter result;
        switch (convert) {
            case NO: {
                result = this.rawFromFieldValueConverter;
                break;
            }
            default: {
                result = this.fromFieldValueConverter;
            }
        }
        if (!result.isConvertedTypeAssignableTo(expectedType)) {
            throw log.invalidAggregationInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return result;
    }
}

