/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.impl;

import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;

public class ElasticsearchIndexFieldType<F>
implements IndexValueFieldTypeDescriptor,
IndexFieldType<F> {
    private final Class<F> valueType;
    private final DslConverter<?, ? extends F> dslConverter;
    private final ProjectionConverter<? super F, ?> projectionConverter;
    private final ElasticsearchFieldCodec<F> codec;
    private final ElasticsearchFieldPredicateBuilderFactory predicateBuilderFactory;
    private final ElasticsearchFieldSortBuilderFactory sortBuilderFactory;
    private final ElasticsearchFieldProjectionBuilderFactory projectionBuilderFactory;
    private final ElasticsearchFieldAggregationBuilderFactory aggregationBuilderFactory;
    private final PropertyMapping mapping;
    private final String analyzerName;
    private final String searchAnalyzerName;
    private final String normalizerName;

    public ElasticsearchIndexFieldType(Class<F> valueType, DslConverter<?, ? extends F> dslConverter, ProjectionConverter<? super F, ?> projectionConverter, ElasticsearchFieldCodec<F> codec, ElasticsearchFieldPredicateBuilderFactory predicateBuilderFactory, ElasticsearchFieldSortBuilderFactory sortBuilderFactory, ElasticsearchFieldProjectionBuilderFactory projectionBuilderFactory, ElasticsearchFieldAggregationBuilderFactory aggregationBuilderFactory, PropertyMapping mapping) {
        this(valueType, dslConverter, projectionConverter, codec, predicateBuilderFactory, sortBuilderFactory, projectionBuilderFactory, aggregationBuilderFactory, mapping, null, null, null);
    }

    public ElasticsearchIndexFieldType(Class<F> valueType, DslConverter<?, ? extends F> dslConverter, ProjectionConverter<? super F, ?> projectionConverter, ElasticsearchFieldCodec<F> codec, ElasticsearchFieldPredicateBuilderFactory predicateBuilderFactory, ElasticsearchFieldSortBuilderFactory sortBuilderFactory, ElasticsearchFieldProjectionBuilderFactory projectionBuilderFactory, ElasticsearchFieldAggregationBuilderFactory aggregationBuilderFactory, PropertyMapping mapping, String analyzerName, String searchAnalyzerName, String normalizerName) {
        this.valueType = valueType;
        this.dslConverter = dslConverter;
        this.projectionConverter = projectionConverter;
        this.codec = codec;
        this.predicateBuilderFactory = predicateBuilderFactory;
        this.sortBuilderFactory = sortBuilderFactory;
        this.projectionBuilderFactory = projectionBuilderFactory;
        this.aggregationBuilderFactory = aggregationBuilderFactory;
        this.mapping = mapping;
        this.analyzerName = analyzerName;
        this.searchAnalyzerName = searchAnalyzerName;
        this.normalizerName = normalizerName;
    }

    public String toString() {
        return this.mapping.toString();
    }

    public boolean isSearchable() {
        return this.predicateBuilderFactory.isSearchable();
    }

    public boolean isSortable() {
        return this.sortBuilderFactory.isSortable();
    }

    public boolean isProjectable() {
        return this.projectionBuilderFactory.isProjectable();
    }

    public boolean isAggregable() {
        return this.aggregationBuilderFactory.isAggregable();
    }

    public Class<?> dslArgumentClass() {
        return this.dslConverter.getValueType();
    }

    public Class<?> projectedValueClass() {
        return this.projectionConverter.getValueType();
    }

    public Class<?> valueClass() {
        return this.valueType;
    }

    public Optional<String> analyzerName() {
        return Optional.ofNullable(this.analyzerName);
    }

    public Optional<String> normalizerName() {
        return Optional.ofNullable(this.normalizerName);
    }

    public Optional<String> searchAnalyzerName() {
        return Optional.ofNullable(this.searchAnalyzerName);
    }

    public Class<F> getValueType() {
        return this.valueType;
    }

    public ElasticsearchFieldCodec<F> getCodec() {
        return this.codec;
    }

    public ElasticsearchFieldPredicateBuilderFactory getPredicateBuilderFactory() {
        return this.predicateBuilderFactory;
    }

    public ElasticsearchFieldSortBuilderFactory getSortBuilderFactory() {
        return this.sortBuilderFactory;
    }

    public ElasticsearchFieldProjectionBuilderFactory getProjectionBuilderFactory() {
        return this.projectionBuilderFactory;
    }

    public ElasticsearchFieldAggregationBuilderFactory getAggregationBuilderFactory() {
        return this.aggregationBuilderFactory;
    }

    public PropertyMapping getMapping() {
        return this.mapping;
    }
}

