/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;

class ElasticsearchGeoPointSpatialWithinPolygonPredicateBuilder
extends AbstractElasticsearchSingleFieldPredicateBuilder
implements SpatialWithinPolygonPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor GEO_POLYGON_ACCESSOR = JsonAccessor.root().property("geo_polygon").asObject();
    private static final String POINTS_PROPERTY_NAME = "points";
    private JsonArray pointsArray;

    ElasticsearchGeoPointSpatialWithinPolygonPredicateBuilder(String absoluteFieldPath, List<String> nestedPathHierarchy) {
        super(absoluteFieldPath, nestedPathHierarchy);
    }

    public void polygon(GeoPolygon polygon) {
        this.pointsArray = new JsonArray();
        for (GeoPoint point : polygon.getPoints()) {
            JsonArray pointArray = new JsonArray();
            pointArray.add((Number)point.getLongitude());
            pointArray.add((Number)point.getLatitude());
            this.pointsArray.add((JsonElement)pointArray);
        }
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        JsonObject pointsObject = new JsonObject();
        pointsObject.add(POINTS_PROPERTY_NAME, (JsonElement)this.pointsArray);
        innerObject.add(this.absoluteFieldPath, (JsonElement)pointsObject);
        GEO_POLYGON_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }
}

