/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractElasticsearchFieldSortBuilderFactory<F>
implements ElasticsearchFieldSortBuilderFactory {
    protected static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final boolean sortable;
    protected final ElasticsearchFieldCodec<F> codec;

    public AbstractElasticsearchFieldSortBuilderFactory(boolean sortable, ElasticsearchFieldCodec<F> codec) {
        this.sortable = sortable;
        this.codec = codec;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public boolean hasCompatibleCodec(ElasticsearchFieldSortBuilderFactory obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ElasticsearchStandardFieldSortBuilderFactory other = (ElasticsearchStandardFieldSortBuilderFactory)obj;
        return this.sortable == other.sortable && this.codec.isCompatibleWith(other.codec);
    }

    protected void checkSortable(String absoluteFieldPath) {
        if (!this.sortable) {
            throw log.unsortableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }
}

