/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.sort.impl;

import java.util.List;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchGeoPointFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.AbstractElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchDistanceSortBuilder;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;

public class ElasticsearchGeoPointFieldSortBuilderFactory
extends AbstractElasticsearchFieldSortBuilderFactory<GeoPoint> {
    public ElasticsearchGeoPointFieldSortBuilderFactory(boolean sortable) {
        super(sortable, ElasticsearchGeoPointFieldCodec.INSTANCE);
    }

    @Override
    public FieldSortBuilder<ElasticsearchSearchSortBuilder> createFieldSortBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, ElasticsearchCompatibilityChecker converterChecker) {
        throw log.traditionalSortNotSupportedByGeoPoint(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public DistanceSortBuilder<ElasticsearchSearchSortBuilder> createDistanceSortBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, GeoPoint center) {
        this.checkSortable(absoluteFieldPath);
        return new ElasticsearchDistanceSortBuilder(searchContext, absoluteFieldPath, nestedPathHierarchy, center);
    }

    @Override
    public boolean hasCompatibleConverter(ElasticsearchFieldSortBuilderFactory obj) {
        return true;
    }
}

