/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;

public class ElasticsearchIndexIndexer
implements IndexIndexer {
    private final ElasticsearchWorkBuilderFactory factory;
    private final ElasticsearchSerialWorkOrchestrator orchestrator;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;

    public ElasticsearchIndexIndexer(ElasticsearchWorkBuilderFactory factory, ElasticsearchSerialWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext) {
        this.factory = factory;
        this.orchestrator = orchestrator;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.getTenantIdentifier();
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        String id = referenceProvider.getIdentifier();
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.getRoutingKey();
        JsonObject document = this.indexManagerContext.createDocument(this.tenantId, id, documentContributor);
        SingleDocumentIndexingWork work = (SingleDocumentIndexingWork)this.factory.index(this.indexManagerContext.getMappedTypeName(), referenceProvider.getEntityIdentifier(), this.indexManagerContext.getElasticsearchIndexWriteName(), elasticsearchId, routingKey, document).build();
        return this.orchestrator.submit(work);
    }
}

