/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.BulkWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResult;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;

public class BulkWork
extends AbstractNonBulkableWork<BulkResult> {
    private static final JsonAccessor<JsonArray> BULK_ITEMS = JsonAccessor.root().property("items").asArray();

    protected BulkWork(Builder builder) {
        super(builder);
    }

    @Override
    protected BulkResult generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject parsedResponseBody = response.getBody();
        JsonArray resultItems = BULK_ITEMS.get(parsedResponseBody).orElseGet(JsonArray::new);
        return new BulkResultImpl(resultItems);
    }

    private static class BulkResultImpl
    implements BulkResult {
        private final JsonArray results;

        public BulkResultImpl(JsonArray results) {
            this.results = results;
        }

        @Override
        public <T> T extract(ElasticsearchWorkExecutionContext context, BulkableWork<T> work, int index) {
            JsonObject bulkItemResponse = this.results.get(index).getAsJsonObject();
            return work.handleBulkResult(context, bulkItemResponse);
        }
    }

    public static class Builder
    extends AbstractNonBulkableWork.AbstractBuilder<Builder>
    implements BulkWorkBuilder {
        private final List<? extends BulkableWork<?>> bulkableWorks;
        private DocumentRefreshStrategy refreshStrategy = DocumentRefreshStrategy.NONE;

        public Builder(List<? extends BulkableWork<?>> bulkableWorks) {
            super(DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.bulkableWorks = bulkableWorks;
        }

        @Override
        public Builder refresh(DocumentRefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(Paths._BULK);
            switch (this.refreshStrategy) {
                case FORCE: {
                    builder.param("refresh", true);
                    break;
                }
            }
            for (BulkableWork<?> work : this.bulkableWorks) {
                builder.body(work.getBulkableActionMetadata());
                JsonObject actionBody = work.getBulkableActionBody();
                if (actionBody == null) continue;
                builder.body(actionBody);
            }
            return builder.build();
        }

        @Override
        public BulkWork build() {
            return new BulkWork(this);
        }
    }
}

