package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.util.common.SearchException;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import java.lang.String;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import java.lang.Number;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.jboss.logging.BasicLogger;
import java.util.List;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import java.time.Duration;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.util.common.data.Range;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import java.lang.Integer;
import org.hibernate.search.util.common.SearchTimeoutException;
import com.google.gson.JsonElement;
import org.hibernate.search.engine.search.projection.SearchProjection;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.search.engine.search.sort.SearchSort;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String elasticsearchRequestFailed$str() {
        return "HSEARCH400007: Elasticsearch request failed: %3$s\nRequest: %1$s\nResponse: %2$s";
    }
    @Override
    public final SearchException elasticsearchRequestFailed(final ElasticsearchRequest request, final ElasticsearchResponse response, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchRequestFailed$str(), new ElasticsearchRequestFormatter(request), new ElasticsearchResponseFormatter(response), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String elasticsearchBulkedRequestFailed$str() {
        return "HSEARCH400008: Elasticsearch bulked request failed: %3$s\nRequest metadata: %1$sResponse: %2$s";
    }
    @Override
    public final SearchException elasticsearchBulkedRequestFailed(final JsonObject requestMetadata, final JsonObject response, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchBulkedRequestFailed$str(), new ElasticsearchJsonObjectFormatter(requestMetadata), new ElasticsearchJsonObjectFormatter(response), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchRequestTimeout$str() {
        return "HSEARCH400010: Elasticsearch connection time-out; check the cluster status, it should be 'green'";
    }
    @Override
    public final SearchException elasticsearchRequestTimeout() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchRequestTimeout$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchMappingCreationFailed$str() {
        return "HSEARCH400020: Could not create mapping for index '%1$s': %2$s";
    }
    @Override
    public final SearchException elasticsearchMappingCreationFailed(final String indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchMappingCreationFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexStatus$str() {
        return "HSEARCH400022: Invalid index status: '%1$s'. Valid statuses are: %2$s.";
    }
    @Override
    public final SearchException invalidIndexStatus(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexStatus$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedIndexStatus$str() {
        return "HSEARCH400024: Index '%1$s' failed to reach status '%2$s' after %3$s.";
    }
    @Override
    public final SearchException unexpectedIndexStatus(final URLEncodedString indexName, final String expected, final String timeoutAndUnit, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedIndexStatus$str(), indexName, expected, timeoutAndUnit), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchIndexMetadataRetrievalFailed$str() {
        return "HSEARCH400034: Could not retrieve the index metadata from Elasticsearch";
    }
    @Override
    public final SearchException elasticsearchIndexMetadataRetrievalFailed(final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchIndexMetadataRetrievalFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String schemaUpdateFailed$str() {
        return "HSEARCH400035: Could not update mappings in index '%1$s': %2$s";
    }
    @Override
    public final SearchException schemaUpdateFailed(final URLEncodedString indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), schemaUpdateFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexMissing$str() {
        return "HSEARCH400050: Index aliases [%1$s, %2$s] do not point to any index in the Elasticsearch cluster.";
    }
    @Override
    public final SearchException indexMissing(final URLEncodedString write, final URLEncodedString read) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexMissing$str(), write, read));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void executingElasticsearchQuery(final String path, final Map<String, String> parameters, final String bodyParts) {
        super.log.logf(FQCN, DEBUG, null, executingElasticsearchQuery$str(), path, parameters, bodyParts);
    }
    protected String executingElasticsearchQuery$str() {
        return "HSEARCH400053: Executing Elasticsearch query on '%s' with parameters '%s': <%s>";
    }
    protected String tokenizerNamingConflict$str() {
        return "HSEARCH400055: Multiple tokenizer definitions with the same name: '%1$s'. The tokenizer names must be unique.";
    }
    @Override
    public final SearchException tokenizerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenizerNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String charFilterNamingConflict$str() {
        return "HSEARCH400056: Multiple char filter definitions with the same name: '%1$s'. The char filter names must be unique.";
    }
    @Override
    public final SearchException charFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), charFilterNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenFilterNamingConflict$str() {
        return "HSEARCH400057: Multiple token filter definitions with the same name: '%1$s'. The token filter names must be unique.";
    }
    @Override
    public final SearchException tokenFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenFilterNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchSettingsUpdateFailed$str() {
        return "HSEARCH400067: Could not update settings for index '%1$s'";
    }
    @Override
    public final SearchException elasticsearchSettingsUpdateFailed(final Object indexName, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchSettingsUpdateFailed$str(), indexName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void closedIndex(final Object indexName) {
        super.log.logf(FQCN, INFO, null, closedIndex$str(), indexName);
    }
    protected String closedIndex$str() {
        return "HSEARCH400069: Closed Elasticsearch index '%1$s' automatically.";
    }
    @Override
    public final void openedIndex(final Object indexName) {
        super.log.logf(FQCN, INFO, null, openedIndex$str(), indexName);
    }
    protected String openedIndex$str() {
        return "HSEARCH400070: Opened Elasticsearch index '%1$s' automatically.";
    }
    @Override
    public final void usingPasswordOverHttp() {
        super.log.logf(FQCN, WARN, null, usingPasswordOverHttp$str());
    }
    protected String usingPasswordOverHttp$str() {
        return "HSEARCH400073: Hibernate Search will connect to Elasticsearch with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    }
    protected String analyzerNamingConflict$str() {
        return "HSEARCH400074: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    }
    @Override
    public final SearchException analyzerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analyzerNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH400075: Error while applying analysis configuration: %1$s";
    }
    @Override
    public final SearchException unableToApplyAnalysisConfiguration(final String errorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyAnalysisConfiguration$str(), errorMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    }
    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchAnalyzerDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchTokenizerDefinition$str() {
        return "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    }
    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenizerDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchCharFilterDefinition$str() {
        return "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    }
    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchCharFilterDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    }
    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenFilterDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToDetectElasticsearchVersion$str() {
        return "HSEARCH400080: Failed to detect the Elasticsearch version running on the cluster: %s";
    }
    @Override
    public final SearchException failedToDetectElasticsearchVersion(final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToDetectElasticsearchVersion$str(), causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedElasticsearchVersion$str() {
        return "HSEARCH400081: An unsupported Elasticsearch version runs on the Elasticsearch cluster: '%s'. Please refer to the documentation to know which versions are supported.";
    }
    @Override
    public final SearchException unsupportedElasticsearchVersion(final ElasticsearchVersion version) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedElasticsearchVersion$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void executedRequest(final String method, final String path, final Map<String, String> getParameters, final int bodyParts, final long timeInMs, final int responseStatusCode, final String responseStatusMessage) {
        super.log.logf(FQCN, DEBUG, null, executedRequest7$str(), method, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage);
    }
    protected String executedRequest7$str() {
        return "HSEARCH400082: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'.";
    }
    @Override
    public final void unknownElasticsearchVersion(final ElasticsearchVersion version) {
        super.log.logf(FQCN, WARN, null, unknownElasticsearchVersion$str(), version);
    }
    protected String unknownElasticsearchVersion$str() {
        return "HSEARCH400085: Hibernate Search may not work correctly, because an unknown Elasticsearch version runs on the Elasticsearch cluster: '%s'.";
    }
    protected String normalizerNamingConflict$str() {
        return "HSEARCH400086: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    }
    @Override
    public final SearchException normalizerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), normalizerNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToParseElasticsearchResponse$str() {
        return "HSEARCH400089: Failed to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'.";
    }
    @Override
    public final SearchException failedToParseElasticsearchResponse(final int statusCode, final String statusPhrase, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToParseElasticsearchResponse$str(), statusCode, statusPhrase), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchResponseIndicatesFailure$str() {
        return "HSEARCH400090: Elasticsearch response indicates a failure.";
    }
    @Override
    public final SearchException elasticsearchResponseIndicatesFailure() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchResponseIndicatesFailure$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void executedRequest(final String method, final String path, final Map<String, String> getParameters, final int bodyParts, final long timeInMs, final int responseStatusCode, final String responseStatusMessage, final String requestBodyParts, final String responseBody) {
        super.log.logf(FQCN, TRACE, null, executedRequest9$str(), method, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody);
    }
    protected String executedRequest9$str() {
        return "HSEARCH400093: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    }
    protected String cannotMixElasticsearchScopeWithOtherType$str() {
        return "HSEARCH400502: A multi-index scope cannot include both an Elasticsearch index and another type of index. Base scope was: '%1$s', Elasticsearch index was: '%2$s'";
    }
    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherType(final IndexScopeBuilder baseScope, final ElasticsearchIndexManager elasticsearchIndex, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchScopeWithOtherType$str(), baseScope, elasticsearchIndex), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchScopeWithOtherBackend$str() {
        return "HSEARCH400503: A multi-index scope cannot span multiple Elasticsearch backends. Base scope was: '%1$s', index from another backend was: '%2$s'";
    }
    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherBackend(final IndexScopeBuilder baseScope, final ElasticsearchIndexManager indexFromOtherBackend, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForSearch$str() {
        return "HSEARCH400504: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForSearch(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForSearch$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchExtensionOnUnknownType$str() {
        return "HSEARCH400506: The Elasticsearch extension can only be applied to objects derived from the Elasticsearch backend. Was applied to '%1$s' instead.";
    }
    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchExtensionOnUnknownType$str(), context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return "HSEARCH400508: An Elasticsearch query cannot include search predicates built using a non-Elasticsearch search scope. Given predicate was: '%1$s'";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(final SearchPredicate predicate) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonObjectFieldForNestedQuery$str() {
        return "HSEARCH400509: Field '%1$s' is not an object field.";
    }
    @Override
    public final SearchException nonObjectFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonNestedFieldForNestedQuery$str() {
        return "HSEARCH400510: Object field '%1$s' is not stored as nested.";
    }
    @Override
    public final SearchException nonNestedFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return "HSEARCH400511: An Elasticsearch query cannot include search sorts built using a non-Elasticsearch search scope. Given sort was: '%1$s'";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(final SearchSort sort) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return "HSEARCH400514: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    }
    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(final String indexName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH400515: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidMultiTenancyStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH400516: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    }
    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(final String tenantId, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH400517: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    }
    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyEnabledButNoTenantIdProvided$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clientUnwrappingWithUnkownType$str() {
        return "HSEARCH400518: Attempt to unwrap the Elasticsearch low-level client to %1$s, but the client can only be unwrapped to %2$s.";
    }
    @Override
    public final SearchException clientUnwrappingWithUnkownType(final Class<?> requestedClass, final Class<?> actualClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), clientUnwrappingWithUnkownType$str(), requestedClass, actualClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH400519: Attempt to unwrap an Elasticsearch backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException backendUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH400520: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }
    @Override
    public final SearchException indexSchemaNodeNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNodeNameConflict$str(), name), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rangesNotSupportedByGeoPoint$str() {
        return "HSEARCH400523: Range lookups (range predicates, range aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.";
    }
    @Override
    public final SearchException rangesNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangesNotSupportedByGeoPoint$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String directValueLookupNotSupportedByGeoPoint$str() {
        return "HSEARCH400524: Direct value lookups (match predicates, terms aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.";
    }
    @Override
    public final SearchException directValueLookupNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), directValueLookupNotSupportedByGeoPoint$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH400525: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldForDocumentElement(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchResponseMissingData$str() {
        return "HSEARCH400526: Expected data was missing in the Elasticsearch response.";
    }
    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        final AssertionFailure result = new AssertionFailure(String.format(getLoggingLocale(), elasticsearchResponseMissingData$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return "HSEARCH400527: Spatial predicates are not supported by this field's type.";
    }
    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), spatialPredicatesNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String distanceOperationsNotSupportedByFieldType$str() {
        return "HSEARCH400528: Distance related operations are not supported by this field's type.";
    }
    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), distanceOperationsNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(final int ceiling) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str(), ceiling));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingIndexNames$str() {
        return "HSEARCH400530: Conflicting index names: Hibernate Search indexes '%1$s' and '%2$s' both target the name or alias '%3$s'";
    }
    @Override
    public final SearchException conflictingIndexNames(final String firstHibernateSearchIndexName, final String secondHibernateSearchIndexName, final String nameOrAlias) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, nameOrAlias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchResponseUnknownIndexName$str() {
        return "HSEARCH400531: Could not resolve index name '%1$s' to an entity type: %2$s";
    }
    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(final String elasticsearchIndexName, final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConvertDslParameter$str() {
        return "HSEARCH400532: Unable to convert DSL parameter: %1$s";
    }
    @Override
    public final SearchException cannotConvertDslParameter(final String errorMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConvertDslParameter$str(), errorMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH400533: Attempt to unwrap an Elasticsearch index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexManagerUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchTypedAnalyzerDefinition$str() {
        return "HSEARCH400534: Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.";
    }
    @Override
    public final SearchException invalidElasticsearchTypedAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTypedAnalyzerDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH400535: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    }
    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(final String analyzerName, final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH400536: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH400537: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    }
    @Override
    public final SearchException analysisComponentParameterConflict(final String name, final JsonElement value1, final JsonElement value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analysisComponentParameterConflict$str(), name, value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return "HSEARCH400538: An Elasticsearch query cannot include search projections built using a non-Elasticsearch search scope. Given projection was: '%1$s'";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(final SearchProjection<?> projection) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidProjectionInvalidType$str() {
        return "HSEARCH400539: Invalid type '%2$s' for projection on field '%1$s'.";
    }
    @Override
    public final SearchException invalidProjectionInvalidType(final String absoluteFieldPath, final Class<?> type, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidProjectionInvalidType$str(), absoluteFieldPath, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return "HSEARCH400540: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    }
    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), traditionalSortNotSupportedByGeoPoint$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldTypesForPredicate$str() {
        return "HSEARCH400541: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingFieldTypesForPredicate(final String absoluteFieldPath, final ElasticsearchFieldPredicateBuilderFactory component1, final ElasticsearchFieldPredicateBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldTypesForSort$str() {
        return "HSEARCH400542: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingFieldTypesForSort(final String absoluteFieldPath, final ElasticsearchFieldSortBuilderFactory component1, final ElasticsearchFieldSortBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldTypesForProjection$str() {
        return "HSEARCH400543: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingFieldTypesForProjection(final String absoluteFieldPath, final ElasticsearchFieldProjectionBuilderFactory component1, final ElasticsearchFieldProjectionBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToShutdownBackend$str() {
        return "HSEARCH400544: Failed to shut down the Elasticsearch backend.";
    }
    @Override
    public final SearchException failedToShutdownBackend(final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToShutdownBackend$str()), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotGuessFieldType$str() {
        return "HSEARCH400545: Cannot guess field type for input type %1$s.";
    }
    @Override
    public final SearchException cannotGuessFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessFieldType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(inputType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonProjectableField$str() {
        return "HSEARCH400547: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    }
    @Override
    public final SearchException nonProjectableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonProjectableField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsortableField$str() {
        return "HSEARCH400548: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";
    }
    @Override
    public final SearchException unsortableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsortableField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingIdentifierTypesForPredicate$str() {
        return "HSEARCH400549: Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException conflictingIdentifierTypesForPredicate(final ToDocumentIdentifierValueConverter<?> component1, final ToDocumentIdentifierValueConverter<?> component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingIdentifierTypesForPredicate$str(), component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToShutdownIndexManager$str() {
        return "HSEARCH400550: Failed to shut down the Elasticsearch index manager with name '%1$s'.";
    }
    @Override
    public final SearchException failedToShutdownIndexManager(final String indexName, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToShutdownIndexManager$str(), indexName), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String textPredicatesNotSupportedByFieldType$str() {
        return "HSEARCH400553: Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.";
    }
    @Override
    public final SearchException textPredicatesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), textPredicatesNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteFieldDefinition$str() {
        return "HSEARCH400554: Incomplete field definition. You must call toReference() to complete the field definition.";
    }
    @Override
    public final SearchException incompleteFieldDefinition(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompleteFieldDefinition$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH400555: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }
    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCreateReferenceMultipleTimes$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchVersion$str() {
        return "HSEARCH400556: Invalid Elasticsearch version: '%1$s'. The version must be in the form 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example '7.0' or just '7'.";
    }
    @Override
    public final SearchException invalidElasticsearchVersion(final String versionString) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchVersion$str(), versionString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedElasticsearchVersion$str() {
        return "HSEARCH400559: Unexpected Elasticsearch version running on the cluster: '%2$s'. Hibernate Search was configured for Elasticsearch '%1$s'.";
    }
    @Override
    public final SearchException unexpectedElasticsearchVersion(final ElasticsearchVersion configuredVersion, final ElasticsearchVersion actualVersion) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedElasticsearchVersion$str(), configuredVersion, actualVersion));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String skipAnalysisOnKeywordField$str() {
        return "HSEARCH400560: Elasticsearch backend does not support skip analysis on not analyzed field: '%1$s'.";
    }
    @Override
    public final SearchException skipAnalysisOnKeywordField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), skipAnalysisOnKeywordField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ambiguousElasticsearchVersion$str() {
        return "HSEARCH400561: Ambiguous Elasticsearch version: '%s'. This version matches multiple dialects. Please use a more precise version to remove the ambiguity.";
    }
    @Override
    public final SearchException ambiguousElasticsearchVersion(final ElasticsearchVersion version) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), ambiguousElasticsearchVersion$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH400562: Index-null-as option is not supported on analyzed field. Trying to define the analyzer: '%1$s' together with index null as: '%2$s'.";
    }
    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(final String analyzerName, final String indexNullAs, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH400563: Multiple values were added to single-valued field '%1$s'. Declare the field as multi-valued in order to allow this.";
    }
    @Override
    public final SearchException multipleValuesForSingleValuedField(final String absolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleValuesForSingleValuedField$str(), absolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresIndexName$str() {
        return "HSEARCH400564: explain(String id) cannot be used when the query targets multiple indexes. Use explain(String indexName, String id) and pass one of %1$s as the index name.";
    }
    @Override
    public final SearchException explainRequiresIndexName(final Set<String> targetedIndexNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresIndexName$str(), targetedIndexNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH400565: The given mapped type name '%2$s' is not among the mapped type targeted by this query: %1$s.";
    }
    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(final Set<String> targetedTypeNames, final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainUnknownDocument$str() {
        return "HSEARCH400566: Document with id '%1$s' does not exist in the targeted index and thus its match cannot be explained.";
    }
    @Override
    public final SearchException explainUnknownDocument(final URLEncodedString id) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainUnknownDocument$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void interruptedWhileWaitingForIndexActivity(final String name, final InterruptedException e) {
        super.log.logf(FQCN, WARN, e, interruptedWhileWaitingForIndexActivity$str(), name);
    }
    protected String interruptedWhileWaitingForIndexActivity$str() {
        return "HSEARCH400567: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    }
    protected String nullDecimalScale$str() {
        return "HSEARCH400568: Impossible to detect a decimal scale to use for this field. If the value is bridged, set '.asBigDecimal().decimalScale( int )' in the bind, else verify your mapping.";
    }
    @Override
    public final SearchException nullDecimalScale(final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullDecimalScale$str()), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scaledNumberTooLarge$str() {
        return "HSEARCH400569: The value '%1$s' cannot be indexed because its absolute value is too large.";
    }
    @Override
    public final SearchException scaledNumberTooLarge(final Number value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), scaledNumberTooLarge$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDecimalScale$str() {
        return "HSEARCH400570: Positive decimal scale ['%1$s'] is not allowed for BigInteger fields, since a BigInteger value cannot have any decimal digits.";
    }
    @Override
    public final SearchException invalidDecimalScale(final Integer decimalScale, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDecimalScale$str(), decimalScale), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonSearchableField$str() {
        return "HSEARCH400571: Field '%1$s' is not searchable. Make sure the field is marked as searchable.";
    }
    @Override
    public final SearchException nonSearchableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonSearchableField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH400572: The predicate '%1$s' is defined on a scope targeting different indexes. Predicate is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }
    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(final SearchPredicate predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH400573: The sort '%1$s' is defined on a scope targeting different indexes. Sort is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }
    @Override
    public final SearchException sortDefinedOnDifferentIndexes(final SearchSort predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), sortDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH400574: The projection '%1$s' is defined on a scope targeting different indexes. Projection is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }
    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(final SearchProjection<?> predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), projectionDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingNestedDocumentPaths$str() {
        return "HSEARCH400575: Multiple index conflicting models on nested document paths targeting '%1$s'. '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingNestedDocumentPaths(final String absoluteFieldPath, final String nestedDocumentPath1, final String nestedDocumentPath2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingNestedDocumentPaths$str(), absoluteFieldPath, nestedDocumentPath1, nestedDocumentPath2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH400576: Cannot apply an analyzer on an aggregable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonAggregableField$str() {
        return "HSEARCH400577: Aggregations are not enabled for field '%1$s'. Make sure the field is marked as aggregable.";
    }
    @Override
    public final SearchException nonAggregableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonAggregableField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAggregationInvalidType$str() {
        return "HSEARCH400578: Invalid type '%2$s' for aggregation on field '%1$s'.";
    }
    @Override
    public final SearchException invalidAggregationInvalidType(final String absoluteFieldPath, final Class<?> type, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAggregationInvalidType$str(), absoluteFieldPath, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldTypesForAggregation$str() {
        return "HSEARCH400579: Multiple conflicting types to build an aggregation for field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingFieldTypesForAggregation(final String absoluteFieldPath, final ElasticsearchFieldAggregationBuilderFactory component1, final ElasticsearchFieldAggregationBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForAggregation$str(), absoluteFieldPath, component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str() {
        return "HSEARCH400580: Elasticsearch range aggregations only accept ranges in the canonical form: (-Infinity, <value>) or [<value1>, <value2>) or [<value>, +Infinity). The given range is not in canonical form: '%1$s'.";
    }
    @Override
    public final SearchException elasticsearchRangeAggregationRequiresCanonicalFormForRanges(final Range<?> range) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str(), range));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherAggregations$str() {
        return "HSEARCH400581: An Elasticsearch query cannot include search aggregations built using a non-Elasticsearch search scope. Given aggregation was: '%1$s'";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherAggregations(final SearchAggregation<?> aggregation) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherAggregations$str(), aggregation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH400582: The aggregation '%1$s' is defined on a scope targeting different indexes. Aggregation is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }
    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(final SearchAggregation<?> aggregation, final Set<String> aggregationIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String termsAggregationsNotSupportedByAnalyzedTextFieldType$str() {
        return "HSEARCH400583: Terms aggregations are not supported by this field's type (string field with analyzed). Use a normalized field instead.";
    }
    @Override
    public final SearchException termsAggregationsNotSupportedByAnalyzedTextFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), termsAggregationsNotSupportedByAnalyzedTextFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rangeAggregationsNotSupportedByFieldType$str() {
        return "HSEARCH400584: Range aggregations are not supported by this field's type.";
    }
    @Override
    public final SearchException rangeAggregationsNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangeAggregationsNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateAggregationKey$str() {
        return "HSEARCH400585: Multiple aggregations with the same key: '%1$s'";
    }
    @Override
    public final SearchException duplicateAggregationKey(final AggregationKey key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), duplicateAggregationKey$str(), new org.hibernate.search.engine.logging.spi.AggregationKeyFormatter(key)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingNestedDocumentPathHierarchy$str() {
        return "HSEARCH400586: Multiple index conflicting models on nested document paths targeting '%1$s'. '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingNestedDocumentPathHierarchy(final String absoluteFieldPath, final List<String> nestedDocumentPathHierarchy1, final List<String> nestedDocumentPathHierarchy2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingNestedDocumentPathHierarchy$str(), absoluteFieldPath, nestedDocumentPathHierarchy1, nestedDocumentPathHierarchy2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH400587: Cannot apply a search analyzer if an analyzer has not been defined on the same field. Search analyzer: '%1$s'.";
    }
    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(final String searchAnalyzer, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchFailedBecauseOfBulkFailure$str() {
        return "HSEARCH400588: The operation failed due to the failure of the call to the bulk REST API.";
    }
    @Override
    public final SearchException elasticsearchFailedBecauseOfBulkFailure(final Throwable bulkFailure) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchFailedBecauseOfBulkFailure$str()), bulkFailure);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHostAndPort$str() {
        return "HSEARCH400589: Invalid host/port: '%1$s'. The host/port string must use the format 'host:port', for example 'mycompany.com:9200' The URI scheme ('http://', 'https://') must not be included.";
    }
    @Override
    public final SearchException invalidHostAndPort(final String hostAndPort, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidHostAndPort$str(), hostAndPort), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timedOut$str() {
        return "HSEARCH400590: Request exceeded the timeout of %1$s: '%2$s'.";
    }
    @Override
    public final SearchTimeoutException timedOut(final Duration timeout, final ElasticsearchRequest request) {
        final SearchTimeoutException result = new SearchTimeoutException(String.format(getLoggingLocale(), timedOut$str(), new org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter(timeout), new ElasticsearchRequestFormatter(request)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTypeNameMappingStrategyName$str() {
        return "HSEARCH400591: Invalid name for the type-name mapping strategy: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidTypeNameMappingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidTypeNameMappingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingTypeFieldInDocument$str() {
        return "HSEARCH400592: Missing field '%1$s' for one of the search hits. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }
    @Override
    public final SearchException missingTypeFieldInDocument(final String fieldName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingTypeFieldInDocument$str(), fieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str() {
        return "HSEARCH400593: Index aliases [%1$s, %2$s] are assigned to a single Hibernate Search index,  but they are already defined in Elasticsearch and point to multiple distinct indexes: %3$s.";
    }
    @Override
    public final SearchException elasticsearchIndexNameAndAliasesMatchMultipleIndexes(final URLEncodedString write, final URLEncodedString read, final Set<String> matchingIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str(), write, read, matchingIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexPrimaryName$str() {
        return "HSEARCH400594: Index primary name  '%1$s' does not match the expected pattern '%2$s'.";
    }
    @Override
    public final SearchException invalidIndexPrimaryName(final String elasticsearchIndexName, final Pattern pattern) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexPrimaryName$str(), elasticsearchIndexName, pattern));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexUniqueKey$str() {
        return "HSEARCH400595: Unique key '%1$s' extracted from the index name does not match any of %2$s";
    }
    @Override
    public final SearchException invalidIndexUniqueKey(final String uniqueKey, final Set<String> knownKeys) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexUniqueKey$str(), uniqueKey, knownKeys));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sameWriteAndReadAliases$str() {
        return "HSEARCH400596: Write alias and read alias must be different, but were set to the same value: '%1$s'.";
    }
    @Override
    public final SearchException sameWriteAndReadAliases(final URLEncodedString writeAndReadAlias, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), sameWriteAndReadAliases$str(), writeAndReadAlias), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchVersionCheckConfiguration$str() {
        return "HSEARCH400597: Invalid Elasticsearch version: '%1$s'. When version_check.enabled is set to false,  the version must at least be in the form 'x.y', where 'x' and 'y' are integers";
    }
    @Override
    public final SearchException invalidElasticsearchVersionCheckConfiguration(final String versionString) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchVersionCheckConfiguration$str(), versionString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String lifecycleStrategyMovedToMapper$str() {
        return "HSEARCH400598: The lifecycle strategy cannot be set at the index level anymore. Set the schema management strategy via the property 'hibernate.search.schema_management.strategy' instead.";
    }
    @Override
    public final SearchException lifecycleStrategyMovedToMapper() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), lifecycleStrategyMovedToMapper$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String simpleQueryStringSpanningMultipleNestedPaths$str() {
        return "HSEARCH400599: Simple query string targets fields [%1$s, %3$s] spanning multiple nested paths: %2$s, %4$s.";
    }
    @Override
    public final SearchException simpleQueryStringSpanningMultipleNestedPaths(final String fieldPath1, final String nestedPath1, final String fieldPath2, final String nestedPath2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), simpleQueryStringSpanningMultipleNestedPaths$str(), fieldPath1, nestedPath1, fieldPath2, nestedPath2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotComputeMedianAcrossNested$str() {
        return "HSEARCH400600: Cannot compute the median across nested documents.";
    }
    @Override
    public final SearchException cannotComputeMedianAcrossNested(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotComputeMedianAcrossNested$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotComputeSumOrAvgOrMedianForStringField$str() {
        return "HSEARCH400601: Cannot compute the sum, average or median of a text field. Only min and max are supported.";
    }
    @Override
    public final SearchException cannotComputeSumOrAvgOrMedianForStringField(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotComputeSumOrAvgOrMedianForStringField$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotComputeSumForTemporalField$str() {
        return "HSEARCH400602: Cannot compute the sum of a temporal field. Only min, max, avg and median are supported.";
    }
    @Override
    public final SearchException cannotComputeSumForTemporalField(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotComputeSumForTemporalField$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotComputeSumForDistanceSort$str() {
        return "HSEARCH400603: Cannot compute the sum for a distance sort. Only min, max, avg and median are supported.";
    }
    @Override
    public final SearchException cannotComputeSumForDistanceSort(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotComputeSumForDistanceSort$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH400604: Field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH400605: Predicate targets unexpected fields %2$s. Only fields that are contained in the nested object with path '%1$s' are allowed here.";
    }
    @Override
    public final SearchException invalidNestedObjectPathForPredicate(final String nestedObjectPath, final List<String> fieldPaths) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNestedObjectPathForPredicate$str(), nestedObjectPath, fieldPaths));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH400606: Field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH400607: The index field template '%1$s' was added twice. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }
    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaFieldTemplateNameConflict$str(), name), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldValueType$str() {
        return "HSEARCH400608: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldValueType(final Class<?> fieldValueType, final Class<?> invalidValueType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldValueType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(fieldValueType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidValueType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForIndexing$str() {
        return "HSEARCH400609: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForIndexing(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForIndexing$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexElementTypeRootIsNotObjectField$str() {
        return "HSEARCH400610: Invalid type: the index root is not an object field.";
    }
    @Override
    public final SearchException invalidIndexElementTypeRootIsNotObjectField() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexElementTypeRootIsNotObjectField$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexElementTypeValueFieldIsNotObjectField$str() {
        return "HSEARCH400611: Invalid type: '%1$s' is a value field, not an object field.";
    }
    @Override
    public final SearchException invalidIndexElementTypeValueFieldIsNotObjectField(final String absolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexElementTypeValueFieldIsNotObjectField$str(), absolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexElementTypeObjectFieldIsNotValueField$str() {
        return "HSEARCH400612: Invalid type: '%1$s' is an object field, not a value field.";
    }
    @Override
    public final SearchException invalidIndexElementTypeObjectFieldIsNotValueField(final String absolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexElementTypeObjectFieldIsNotValueField$str(), absolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
