/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.util.common.pattern.spi.SimpleGlobPattern;

public abstract class AbstractElasticsearchIndexSchemaFieldTemplate<N> {
    private final SimpleGlobPattern absolutePathGlob;
    private final IndexFieldInclusion inclusion;
    private final boolean multiValued;

    AbstractElasticsearchIndexSchemaFieldTemplate(ElasticsearchIndexSchemaObjectNode declaringParent, SimpleGlobPattern absolutePathGlob, IndexFieldInclusion inclusion, boolean multiValued) {
        this.absolutePathGlob = absolutePathGlob;
        this.inclusion = declaringParent.getInclusion().compose(inclusion);
        this.multiValued = multiValued;
    }

    public IndexFieldInclusion getInclusion() {
        return this.inclusion;
    }

    N createNodeIfMatching(ElasticsearchIndexModel model, String absolutePath) {
        if (!this.absolutePathGlob.matches(absolutePath)) {
            return null;
        }
        FieldPaths.RelativizedPath relativizedPath = FieldPaths.relativize((String)absolutePath);
        ElasticsearchIndexSchemaObjectNode parent = relativizedPath.parentPath.map(path -> model.getObjectFieldNode((String)path, IndexFieldFilter.ALL)).orElseGet(model::root);
        return this.createNode(parent, relativizedPath.relativePath, this.inclusion, this.multiValued);
    }

    protected abstract N createNode(ElasticsearchIndexSchemaObjectNode var1, String var2, IndexFieldInclusion var3, boolean var4);
}

