/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class AbstractElasticsearchNestableAggregation<A>
extends AbstractElasticsearchAggregation<A> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<String> REQUEST_NESTED_PATH_ACCESSOR = JsonAccessor.root().property("nested").property("path").asString();
    private static final JsonObjectAccessor REQUEST_FILTER_ACCESSOR = JsonAccessor.root().property("filter").asObject();
    private static final String NESTED_NAME = "nested";
    private static final JsonAccessor<JsonObject> REQUEST_AGGREGATIONS_NESTED_ACCESSOR = JsonAccessor.root().property("aggregations").property("nested").asObject();
    private static final JsonAccessor<JsonObject> RESPONSE_NESTED_ACCESSOR = JsonAccessor.root().property("nested").asObject();
    private static final String FILTERED_NAME = "filtered";
    private static final JsonAccessor<JsonObject> REQUEST_AGGREGATIONS_FILTERED_ACCESSOR = JsonAccessor.root().property("aggregations").property("filtered").asObject();
    private static final JsonAccessor<JsonObject> RESPONSE_FILTERED_ACCESSOR = JsonAccessor.root().property("filtered").asObject();
    private final List<String> nestedPathHierarchy;
    private final ElasticsearchSearchPredicateBuilder filterBuilder;

    AbstractElasticsearchNestableAggregation(AbstractBuilder<A> builder) {
        super(builder);
        this.nestedPathHierarchy = builder.nestedPathHierarchy;
        this.filterBuilder = ((AbstractBuilder)builder).filterBuilder;
    }

    @Override
    public final JsonObject request(AggregationRequestContext context) {
        int hierarchyLastIndex;
        JsonObject result = this.doRequest(context);
        if (this.nestedPathHierarchy.isEmpty()) {
            return result;
        }
        if (this.filterBuilder != null) {
            ElasticsearchSearchPredicateContext filterContext = context.getRootPredicateContext().withNestedPath(this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1));
            JsonObject jsonFilter = this.filterBuilder.build(filterContext);
            JsonObject object = new JsonObject();
            REQUEST_FILTER_ACCESSOR.set(object, jsonFilter);
            REQUEST_AGGREGATIONS_FILTERED_ACCESSOR.set(object, result);
            result = object;
        }
        for (int i = hierarchyLastIndex = this.nestedPathHierarchy.size() - 1; i >= 0; --i) {
            String path = this.nestedPathHierarchy.get(i);
            JsonObject object = new JsonObject();
            REQUEST_NESTED_PATH_ACCESSOR.set(object, path);
            REQUEST_AGGREGATIONS_NESTED_ACCESSOR.set(object, result);
            result = object;
        }
        return result;
    }

    protected abstract JsonObject doRequest(AggregationRequestContext var1);

    @Override
    public final A extract(JsonObject aggregationResult, AggregationExtractContext context) {
        int nestedPathHierarchySize = this.nestedPathHierarchy.size();
        JsonObject actualAggregationResult = aggregationResult;
        for (int i = 0; i < nestedPathHierarchySize; ++i) {
            actualAggregationResult = RESPONSE_NESTED_ACCESSOR.get(actualAggregationResult).orElseThrow(log::elasticsearchResponseMissingData);
        }
        if (this.filterBuilder != null) {
            actualAggregationResult = RESPONSE_FILTERED_ACCESSOR.get(actualAggregationResult).orElseThrow(log::elasticsearchResponseMissingData);
        }
        return this.doExtract(actualAggregationResult, context);
    }

    protected abstract A doExtract(JsonObject var1, AggregationExtractContext var2);

    protected final boolean isNested() {
        return !this.nestedPathHierarchy.isEmpty();
    }

    public static abstract class AbstractBuilder<A>
    extends AbstractElasticsearchAggregation.AbstractBuilder<A> {
        protected final String absoluteFieldPath;
        protected final List<String> nestedPathHierarchy;
        private ElasticsearchSearchPredicateBuilder filterBuilder;

        public AbstractBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy) {
            super(searchContext);
            this.absoluteFieldPath = absoluteFieldPath;
            this.nestedPathHierarchy = nestedPathHierarchy;
        }

        public void filter(SearchPredicate filter) {
            if (this.nestedPathHierarchy.isEmpty()) {
                throw log.cannotFilterAggregationOnRootDocumentField(this.absoluteFieldPath, this.getEventContext());
            }
            ElasticsearchSearchPredicateBuilder builder = (ElasticsearchSearchPredicateBuilder)filter;
            builder.checkNestableWithin(this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1));
            this.filterBuilder = builder;
        }

        @Override
        public abstract ElasticsearchSearchAggregation<A> build();

        protected final EventContext getEventContext() {
            return EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath);
        }
    }
}

