/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentFieldValueConvertContextImpl;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextImpl;

public final class ElasticsearchSearchContext {
    private final ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext;
    private final ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext;
    private final Gson userFacingGson;
    private final ElasticsearchSearchSyntax searchSyntax;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchScopeModel scopeModel;

    public ElasticsearchSearchContext(BackendMappingContext mappingContext, Gson userFacingGson, ElasticsearchSearchSyntax searchSyntax, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchScopeModel scopeModel) {
        this.toDocumentIdentifierValueConvertContext = new ToDocumentIdentifierValueConvertContextImpl(mappingContext);
        this.toDocumentFieldValueConvertContext = new ToDocumentFieldValueConvertContextImpl(mappingContext);
        this.userFacingGson = userFacingGson;
        this.searchSyntax = searchSyntax;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.scopeModel = scopeModel;
    }

    public ToDocumentIdentifierValueConvertContext getToDocumentIdentifierValueConvertContext() {
        return this.toDocumentIdentifierValueConvertContext;
    }

    public ToDocumentFieldValueConvertContext getToDocumentFieldValueConvertContext() {
        return this.toDocumentFieldValueConvertContext;
    }

    public Gson getUserFacingGson() {
        return this.userFacingGson;
    }

    public ElasticsearchSearchSyntax getSearchSyntax() {
        return this.searchSyntax;
    }

    public String toElasticsearchId(String tenantId, String id) {
        return this.multiTenancyStrategy.toElasticsearchId(tenantId, id);
    }

    public Set<String> getMappedTypeNames() {
        return this.scopeModel.getMappedTypeNames();
    }

    public Set<String> getHibernateSearchIndexNames() {
        return this.scopeModel.getHibernateSearchIndexNames();
    }

    public Collection<URLEncodedString> getElasticsearchIndexNames() {
        return this.scopeModel.getElasticsearchIndexNames();
    }

    public Map<String, URLEncodedString> getMappedTypeToElasticsearchIndexNames() {
        return this.scopeModel.getMappedTypeToElasticsearchIndexNames();
    }

    public JsonObject getFilterOrNull(String tenantId) {
        return this.multiTenancyStrategy.getFilterOrNull(tenantId);
    }
}

