/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;

public class ElasticsearchMatchIdPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements MatchIdPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final StringToDocumentIdentifierValueConverter RAW_CONVERTER = new StringToDocumentIdentifierValueConverter();
    private static final JsonObjectAccessor IDS_ACCESSOR = JsonAccessor.root().property("ids").asObject();
    private static final JsonAccessor<JsonElement> VALUES_ACCESSOR = JsonAccessor.root().property("values");
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchCompatibilityChecker converterChecker;
    private final ToDocumentIdentifierValueConverter<?> converter;
    private final List<String> values = new ArrayList<String>();

    ElasticsearchMatchIdPredicateBuilder(ElasticsearchSearchContext searchContext, ElasticsearchCompatibilityChecker converterChecker, ToDocumentIdentifierValueConverter<?> converter) {
        this.searchContext = searchContext;
        this.converterChecker = converterChecker;
        this.converter = converter;
    }

    public void value(Object value, ValueConvert valueConvert) {
        ToDocumentIdentifierValueConverter<?> dslToDocumentIdConverter = this.getDslToDocumentIdentifierConverter(valueConvert);
        ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext = this.searchContext.getToDocumentIdentifierValueConvertContext();
        this.values.add(dslToDocumentIdConverter.convertUnknown(value, toDocumentIdentifierValueConvertContext));
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        JsonArray array = this.convert(this.values, context.getTenantId());
        VALUES_ACCESSOR.set(innerObject, (JsonElement)array);
        IDS_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }

    private JsonArray convert(List<String> list, String tenantId) {
        JsonArray jsonArray = new JsonArray(list.size());
        for (String value : list) {
            jsonArray.add(this.searchContext.toElasticsearchId(tenantId, value));
        }
        return jsonArray;
    }

    private ToDocumentIdentifierValueConverter<?> getDslToDocumentIdentifierConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return RAW_CONVERTER;
            }
        }
        this.converterChecker.failIfNotCompatible();
        return this.converter;
    }
}

