/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchScalarFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.format.impl.ElasticsearchDefaultFieldFormatProvider;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchTemporalFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;

abstract class AbstractElasticsearchTemporalIndexFieldTypeOptionsStep<S extends AbstractElasticsearchTemporalIndexFieldTypeOptionsStep<?, F>, F extends TemporalAccessor>
extends AbstractElasticsearchScalarFieldTypeOptionsStep<S, F> {
    AbstractElasticsearchTemporalIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext, Class<F> fieldType) {
        super(buildContext, fieldType, "date");
    }

    @Override
    protected ElasticsearchFieldCodec<F> complete(PropertyMapping mapping) {
        ElasticsearchDefaultFieldFormatProvider defaultFieldFormatProvider = this.getBuildContext().getDefaultFieldFormatProvider();
        mapping.setFormat(defaultFieldFormatProvider.getDefaultMappingFormat(this.getFieldType()));
        DateTimeFormatter formatter = defaultFieldFormatProvider.getDefaultDateTimeFormatter(this.getFieldType());
        return this.createCodec(formatter);
    }

    @Override
    protected ElasticsearchStandardFieldSortBuilderFactory<F> createFieldSortBuilderFactory(boolean resolvedAggregable, DslConverter<?, ? extends F> dslToIndexConverter, DslConverter<F, ? extends F> rawDslToIndexConverter, ElasticsearchFieldCodec<F> codec) {
        return new ElasticsearchTemporalFieldSortBuilderFactory<F>(resolvedAggregable, dslToIndexConverter, rawDslToIndexConverter, codec);
    }

    protected abstract ElasticsearchFieldCodec<F> createCodec(DateTimeFormatter var1);
}

