/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchStandardFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchJsonElementFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchNativeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;

class ElasticsearchNativeIndexFieldTypeOptionsStepImpl
extends AbstractElasticsearchIndexFieldTypeOptionsStep<ElasticsearchNativeIndexFieldTypeOptionsStepImpl, JsonElement>
implements ElasticsearchNativeIndexFieldTypeOptionsStep<ElasticsearchNativeIndexFieldTypeOptionsStepImpl> {
    private final PropertyMapping mapping;

    ElasticsearchNativeIndexFieldTypeOptionsStepImpl(ElasticsearchIndexFieldTypeBuildContext buildContext, PropertyMapping mapping) {
        super(buildContext, JsonElement.class);
        this.mapping = mapping;
    }

    @Override
    protected ElasticsearchNativeIndexFieldTypeOptionsStepImpl thisAsS() {
        return this;
    }

    public IndexFieldType<JsonElement> toIndexFieldType() {
        Gson gson = this.getBuildContext().getUserFacingGson();
        DslConverter dslConverter = this.createDslConverter();
        DslConverter rawDslConverter = this.createRawDslConverter();
        ProjectionConverter projectionConverter = this.createProjectionConverter();
        ProjectionConverter rawProjectionConverter = this.createRawProjectionConverter();
        ElasticsearchJsonElementFieldCodec codec = new ElasticsearchJsonElementFieldCodec(gson);
        return new ElasticsearchIndexFieldType<JsonElement>(this.getFieldType(), dslConverter, projectionConverter, codec, new ElasticsearchStandardFieldPredicateBuilderFactory<JsonElement>(true, dslConverter, rawDslConverter, codec), new ElasticsearchStandardFieldSortBuilderFactory<JsonElement>(true, dslConverter, rawDslConverter, codec), new ElasticsearchStandardFieldProjectionBuilderFactory<JsonElement>(true, projectionConverter, rawProjectionConverter, codec), new ElasticsearchStandardFieldAggregationBuilderFactory<JsonElement>(true, dslConverter, rawDslConverter, projectionConverter, rawProjectionConverter, codec), this.mapping);
    }
}

