/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;

class ElasticsearchTextPhrasePredicateBuilder
extends AbstractElasticsearchSingleFieldPredicateBuilder
implements PhrasePredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor MATCH_PHRASE_ACCESSOR = JsonAccessor.root().property("match_phrase").asObject();
    private static final JsonAccessor<Integer> SLOP_ACCESSOR = JsonAccessor.root().property("slop").asInteger();
    private static final JsonAccessor<JsonElement> QUERY_ACCESSOR = JsonAccessor.root().property("query");
    private static final JsonAccessor<String> ANALYZER_ACCESSOR = JsonAccessor.root().property("analyzer").asString();
    private final ElasticsearchCompatibilityChecker analyzerChecker;
    private Integer slop;
    private JsonElement phrase;
    private String analyzer;

    ElasticsearchTextPhrasePredicateBuilder(String absoluteFieldPath, List<String> nestedPathHierarchy, ElasticsearchCompatibilityChecker analyzerChecker) {
        super(absoluteFieldPath, nestedPathHierarchy);
        this.analyzerChecker = analyzerChecker;
    }

    public void slop(int slop) {
        this.slop = slop;
    }

    public void phrase(String phrase) {
        this.phrase = new JsonPrimitive(phrase);
    }

    public void analyzer(String analyzerName) {
        this.analyzer = analyzerName;
    }

    public void skipAnalysis() {
        this.analyzer("keyword");
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        if (this.analyzer == null) {
            this.analyzerChecker.failIfNotCompatible();
        }
        QUERY_ACCESSOR.set(innerObject, this.phrase);
        if (this.slop != null) {
            SLOP_ACCESSOR.set(innerObject, this.slop);
        }
        if (this.analyzer != null) {
            ANALYZER_ACCESSOR.set(innerObject, this.analyzer);
        }
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        MATCH_PHRASE_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }
}

