/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientUtils;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.spi.JsonLogHelper;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchLogCategories;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LogCategory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchClientImpl
implements ElasticsearchClientImplementor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Log requestLog = (Log)LoggerFactory.make(Log.class, (LogCategory)ElasticsearchLogCategories.REQUEST);
    private final RestClient restClient;
    private final Sniffer sniffer;
    private final ScheduledExecutorService timeoutExecutorService;
    private final int globalTimeoutValue;
    private final TimeUnit globalTimeoutUnit;
    private final Gson gson;
    private final JsonLogHelper jsonLogHelper;

    ElasticsearchClientImpl(RestClient restClient, Sniffer sniffer, ScheduledExecutorService timeoutExecutorService, int globalTimeoutValue, TimeUnit globalTimeoutUnit, Gson gson, JsonLogHelper jsonLogHelper) {
        this.restClient = restClient;
        this.sniffer = sniffer;
        this.timeoutExecutorService = timeoutExecutorService;
        this.globalTimeoutValue = globalTimeoutValue;
        this.globalTimeoutUnit = globalTimeoutUnit;
        this.gson = gson;
        this.jsonLogHelper = jsonLogHelper;
    }

    @Override
    public CompletableFuture<ElasticsearchResponse> submit(ElasticsearchRequest request) {
        CompletionStage result = Futures.create(() -> this.send(request)).thenApply(this::convertResponse);
        if (requestLog.isDebugEnabled()) {
            long startTime = System.nanoTime();
            ((CompletableFuture)result).thenAccept(response -> this.log(request, startTime, (ElasticsearchResponse)response));
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> clientClass) {
        if (RestClient.class.isAssignableFrom(clientClass)) {
            return (T)this.restClient;
        }
        throw log.clientUnwrappingWithUnkownType(clientClass, RestClient.class);
    }

    private CompletableFuture<Response> send(ElasticsearchRequest elasticsearchRequest) {
        HttpEntity entity;
        final CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        try {
            entity = ElasticsearchClientUtils.toEntity(this.gson, elasticsearchRequest);
        }
        catch (IOException | RuntimeException e) {
            completableFuture.completeExceptionally(e);
            return completableFuture;
        }
        this.restClient.performRequestAsync(ElasticsearchClientImpl.toRequest(elasticsearchRequest, entity), new ResponseListener(){

            public void onSuccess(Response response) {
                completableFuture.complete(response);
            }

            public void onFailure(Exception exception) {
                if (exception instanceof ResponseException) {
                    requestLog.debug("ES client issued a ResponseException - not necessarily a problem", exception);
                    completableFuture.complete(((ResponseException)exception).getResponse());
                } else {
                    completableFuture.completeExceptionally(exception);
                }
            }
        });
        long currentTimeoutValue = elasticsearchRequest.timeoutValue() == null ? (long)this.globalTimeoutValue : elasticsearchRequest.timeoutValue();
        TimeUnit currentTimeoutUnit = elasticsearchRequest.timeoutUnit() == null ? this.globalTimeoutUnit : elasticsearchRequest.timeoutUnit();
        ScheduledFuture<?> timeout = this.timeoutExecutorService.schedule(() -> {
            if (!completableFuture.isDone()) {
                completableFuture.completeExceptionally((Throwable)log.timedOut(Duration.ofNanos(currentTimeoutUnit.toNanos(currentTimeoutValue)), elasticsearchRequest));
            }
        }, currentTimeoutValue, currentTimeoutUnit);
        completableFuture.thenRun(() -> timeout.cancel(false));
        return completableFuture;
    }

    private static Request toRequest(ElasticsearchRequest elasticsearchRequest, HttpEntity entity) {
        Request request = new Request(elasticsearchRequest.method(), elasticsearchRequest.path());
        for (Map.Entry<String, String> parameter : elasticsearchRequest.parameters().entrySet()) {
            request.addParameter(parameter.getKey(), parameter.getValue());
        }
        request.setEntity(entity);
        return request;
    }

    private ElasticsearchResponse convertResponse(Response response) {
        try {
            JsonObject body = this.parseBody(response);
            return new ElasticsearchResponse(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), body);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToParseElasticsearchResponse(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), e);
        }
    }

    private JsonObject parseBody(Response response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        Charset charset = ElasticsearchClientImpl.getCharset(entity);
        try (InputStream inputStream = entity.getContent();){
            JsonObject jsonObject;
            try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
                jsonObject = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
            }
            return jsonObject;
        }
    }

    private static Charset getCharset(HttpEntity entity) {
        ContentType contentType = ContentType.get((HttpEntity)entity);
        Charset charset = contentType.getCharset();
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    private void log(ElasticsearchRequest request, long start, ElasticsearchResponse response) {
        long executionTimeNs = System.nanoTime() - start;
        long executionTimeMs = TimeUnit.NANOSECONDS.toMillis(executionTimeNs);
        if (requestLog.isTraceEnabled()) {
            requestLog.executedRequest(request.method(), request.path(), request.parameters(), request.bodyParts().size(), executionTimeMs, response.statusCode(), response.statusMessage(), this.jsonLogHelper.toString(request.bodyParts()), this.jsonLogHelper.toString(response.body()));
        } else {
            requestLog.executedRequest(request.method(), request.path(), request.parameters(), request.bodyParts().size(), executionTimeMs, response.statusCode(), response.statusMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(Sniffer::close, (Object)this.sniffer);
            closer.push(RestClient::close, (Object)this.restClient);
        }
    }
}

