/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldReference;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexObjectFieldReference;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaValueFieldNode;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.document.spi.NoOpDocumentElement;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDocumentObjectBuilder
implements DocumentElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchIndexModel model;
    private final ElasticsearchIndexSchemaObjectNode schemaNode;
    private final JsonObject content;

    public ElasticsearchDocumentObjectBuilder(ElasticsearchIndexModel model) {
        this(model, model.root(), new JsonObject());
    }

    ElasticsearchDocumentObjectBuilder(ElasticsearchIndexModel model, ElasticsearchIndexSchemaObjectNode schemaNode, JsonObject content) {
        this.model = model;
        this.schemaNode = schemaNode;
        this.content = content;
    }

    public <F> void addValue(IndexFieldReference<F> fieldReference, F value) {
        ElasticsearchIndexFieldReference elasticsearchFieldReference = (ElasticsearchIndexFieldReference)fieldReference;
        ElasticsearchIndexSchemaValueFieldNode fieldSchemaNode = elasticsearchFieldReference.getSchemaNode();
        this.addValue(fieldSchemaNode, value);
    }

    public DocumentElement addObject(IndexObjectFieldReference fieldReference) {
        ElasticsearchIndexObjectFieldReference elasticsearchFieldReference = (ElasticsearchIndexObjectFieldReference)fieldReference;
        ElasticsearchIndexSchemaObjectFieldNode fieldSchemaNode = elasticsearchFieldReference.getSchemaNode();
        JsonObject jsonObject = new JsonObject();
        return this.addObject(fieldSchemaNode, jsonObject);
    }

    public void addNullObject(IndexObjectFieldReference fieldReference) {
        ElasticsearchIndexObjectFieldReference elasticsearchFieldReference = (ElasticsearchIndexObjectFieldReference)fieldReference;
        ElasticsearchIndexSchemaObjectFieldNode fieldSchemaNode = elasticsearchFieldReference.getSchemaNode();
        this.addObject(fieldSchemaNode, null);
    }

    public void addValue(String relativeFieldName, Object value) {
        String absoluteFieldPath = FieldPaths.compose((String)this.schemaNode.absolutePath(), (String)relativeFieldName);
        ElasticsearchIndexSchemaValueFieldNode<?> node = this.model.getFieldNode(absoluteFieldPath, IndexFieldFilter.ALL);
        if (node == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.getEventContext());
        }
        this.addValueUnknownType(node, value);
    }

    public DocumentElement addObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        ElasticsearchIndexSchemaObjectFieldNode fieldSchemaNode = this.model.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.getEventContext());
        }
        JsonObject jsonObject = new JsonObject();
        this.addObject(fieldSchemaNode, jsonObject);
        return new ElasticsearchDocumentObjectBuilder(this.model, fieldSchemaNode, jsonObject);
    }

    public void addNullObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        ElasticsearchIndexSchemaObjectFieldNode fieldSchemaNode = this.model.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.getEventContext());
        }
        this.addObject(fieldSchemaNode, null);
    }

    public JsonObject build() {
        return this.content;
    }

    private <F> void addValue(ElasticsearchIndexSchemaValueFieldNode<F> node, F value) {
        ElasticsearchIndexSchemaObjectNode expectedParentNode = node.parent();
        this.checkTreeConsistency(expectedParentNode);
        if (IndexFieldInclusion.EXCLUDED.equals((Object)node.inclusion())) {
            return;
        }
        JsonAccessor<JsonElement> accessor = node.relativeAccessor();
        IndexValueFieldTypeDescriptor type = node.type();
        if (!node.multiValued() && accessor.hasExplicitValue(this.content)) {
            throw log.multipleValuesForSingleValuedField(node.absolutePath());
        }
        accessor.add(this.content, type.codec().encode(value));
    }

    private void addValueUnknownType(ElasticsearchIndexSchemaValueFieldNode<?> node, Object value) {
        if (value == null) {
            this.addValue(node, null);
        } else {
            ElasticsearchIndexSchemaValueFieldNode<?> typeCheckedNode = node.withValueType(value.getClass(), this.model.getEventContext());
            this.addValue(typeCheckedNode, value);
        }
    }

    private DocumentElement addObject(ElasticsearchIndexSchemaObjectFieldNode node, JsonObject value) {
        ElasticsearchIndexSchemaObjectNode expectedParentNode = node.parent();
        this.checkTreeConsistency(expectedParentNode);
        if (IndexFieldInclusion.EXCLUDED.equals((Object)node.inclusion())) {
            return NoOpDocumentElement.get();
        }
        JsonAccessor<JsonElement> accessor = node.relativeAccessor();
        if (!node.multiValued() && accessor.hasExplicitValue(this.content)) {
            throw log.multipleValuesForSingleValuedField(node.absolutePath());
        }
        accessor.add(this.content, (JsonElement)value);
        if (value == null) {
            return NoOpDocumentElement.get();
        }
        return new ElasticsearchDocumentObjectBuilder(this.model, node, value);
    }

    private void checkTreeConsistency(ElasticsearchIndexSchemaObjectNode expectedParentNode) {
        if (!Objects.equals(expectedParentNode, this.schemaNode)) {
            throw log.invalidFieldForDocumentElement(expectedParentNode.absolutePath(), this.schemaNode.absolutePath());
        }
    }
}

