/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexSettings;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexScopeBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchBatchingWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexSchemaManager;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.metamodel.IndexDescriptor;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexManagerImpl
implements IndexManagerImplementor,
ElasticsearchIndexManager,
WorkExecutionIndexManagerContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<String> OBSOLETE_LIFECYCLE_STRATEGY = ConfigurationProperty.forKey((String)"lifecycle.strategy").asString().build();
    private static final ConfigurationProperty<IndexStatus> LIFECYCLE_MINIMAL_REQUIRED_STATUS = ConfigurationProperty.forKey((String)"schema_management.minimal_required_status").as(IndexStatus.class, IndexStatus::of).withDefault((Object)ElasticsearchIndexSettings.Defaults.SCHEMA_MANAGEMENT_MINIMAL_REQUIRED_STATUS).build();
    private static final ConfigurationProperty<Integer> LIFECYCLE_MINIMAL_REQUIRED_STATUS_WAIT_TIMEOUT = ConfigurationProperty.forKey((String)"schema_management.minimal_required_status_wait_timeout").asInteger().withDefault((Object)10000).build();
    private final IndexManagerBackendContext backendContext;
    private final ElasticsearchIndexModel model;
    private final List<DocumentMetadataContributor> documentMetadataContributors;
    private final ElasticsearchBatchingWorkOrchestrator indexingOrchestrator;
    private ElasticsearchIndexSchemaManager schemaManager;

    ElasticsearchIndexManagerImpl(IndexManagerBackendContext backendContext, ElasticsearchIndexModel model, List<DocumentMetadataContributor> documentMetadataContributors) {
        this.backendContext = backendContext;
        this.model = model;
        this.documentMetadataContributors = documentMetadataContributors;
        this.indexingOrchestrator = backendContext.createIndexingOrchestrator(model.hibernateSearchName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "names=" + this.model.names() + "]";
    }

    public void start(IndexManagerStartContext context) {
        try {
            this.schemaManager = this.backendContext.createSchemaManager(this.model, this.createLifecycleExecutionOptions(context.configurationPropertySource()));
            OBSOLETE_LIFECYCLE_STRATEGY.getAndMap(context.configurationPropertySource(), ignored -> {
                throw log.lifecycleStrategyMovedToMapper();
            });
            this.indexingOrchestrator.start(context.configurationPropertySource());
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(AbstractWorkOrchestrator::stop, (Object)this.indexingOrchestrator);
            throw e;
        }
    }

    public CompletableFuture<?> preStop() {
        return this.indexingOrchestrator.preStop();
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.indexingOrchestrator);
            this.schemaManager = null;
        }
        catch (IOException e) {
            throw log.failedToShutdownIndexManager(this.model.hibernateSearchName(), e, this.backendContext.getEventContext());
        }
    }

    @Override
    public String getMappedTypeName() {
        return this.model.mappedTypeName();
    }

    @Override
    public URLEncodedString getElasticsearchIndexWriteName() {
        return this.model.names().getWrite();
    }

    @Override
    public String toElasticsearchId(String tenantId, String id) {
        return this.backendContext.toElasticsearchId(tenantId, id);
    }

    @Override
    public JsonObject createDocument(String tenantId, String id, DocumentContributor documentContributor) {
        ElasticsearchDocumentObjectBuilder builder = new ElasticsearchDocumentObjectBuilder(this.model);
        documentContributor.contribute((DocumentElement)builder);
        JsonObject document = builder.build();
        for (DocumentMetadataContributor contributor : this.documentMetadataContributors) {
            contributor.contribute(document, tenantId, id);
        }
        return document;
    }

    public ElasticsearchIndexModel model() {
        return this.model;
    }

    public IndexSchemaManager schemaManager() {
        return this.schemaManager;
    }

    public <R> IndexIndexingPlan<R> createIndexingPlan(BackendSessionContext sessionContext, EntityReferenceFactory<R> entityReferenceFactory, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.backendContext.createIndexingPlan(this.indexingOrchestrator, this, sessionContext, entityReferenceFactory, refreshStrategy);
    }

    public IndexIndexer createIndexer(BackendSessionContext sessionContext) {
        return this.backendContext.createIndexer(this.indexingOrchestrator, this, sessionContext);
    }

    public IndexWorkspace createWorkspace(DetachedBackendSessionContext sessionContext) {
        return this.backendContext.createWorkspace(this, sessionContext);
    }

    public IndexScopeBuilder createScopeBuilder(BackendMappingContext mappingContext) {
        return new ElasticsearchIndexScopeBuilder(this.backendContext, mappingContext, this);
    }

    public void addTo(IndexScopeBuilder builder) {
        if (!(builder instanceof ElasticsearchIndexScopeBuilder)) {
            throw log.cannotMixElasticsearchScopeWithOtherType(builder, this, this.backendContext.getEventContext());
        }
        ElasticsearchIndexScopeBuilder esBuilder = (ElasticsearchIndexScopeBuilder)builder;
        esBuilder.add(this.backendContext, this);
    }

    public IndexManager toAPI() {
        return this;
    }

    @Override
    public ElasticsearchBackend backend() {
        return this.backendContext.toAPI();
    }

    public IndexDescriptor descriptor() {
        return this.model;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchIndexManager.class)) {
            return (T)this;
        }
        throw log.indexManagerUnwrappingWithUnknownType(clazz, ElasticsearchIndexManager.class, this.getBackendAndIndexEventContext());
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.backendContext.getEventContext().append(EventContexts.fromIndexName((String)this.model.hibernateSearchName()));
    }

    private ElasticsearchIndexLifecycleExecutionOptions createLifecycleExecutionOptions(ConfigurationPropertySource propertySource) {
        return new ElasticsearchIndexLifecycleExecutionOptions((IndexStatus)((Object)LIFECYCLE_MINIMAL_REQUIRED_STATUS.get(propertySource)), (Integer)LIFECYCLE_MINIMAL_REQUIRED_STATUS_WAIT_TIMEOUT.get(propertySource));
    }
}

