/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.layout.impl;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class IndexNames {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String hibernateSearch;
    private final URLEncodedString write;
    private final URLEncodedString read;

    public static String normalizeName(String indexName) {
        String esIndexName = indexName.toLowerCase(Locale.ENGLISH);
        if (!esIndexName.equals(indexName)) {
            log.debugf("Normalizing index name from '%1$s' to '%2$s'", indexName, esIndexName);
        }
        return esIndexName;
    }

    public static URLEncodedString encodeName(String name) {
        return URLEncodedString.fromString(IndexNames.normalizeName(name));
    }

    public IndexNames(String hibernateSearch, URLEncodedString write, URLEncodedString read) {
        this.hibernateSearch = hibernateSearch;
        this.write = write;
        this.read = read;
    }

    public String toString() {
        return "IndexNames[hibernateSearch=" + this.hibernateSearch + ", read=" + this.read + ", write=" + this.write + "]";
    }

    public String getHibernateSearch() {
        return this.hibernateSearch;
    }

    public URLEncodedString getWrite() {
        return this.write;
    }

    public URLEncodedString getRead() {
        return this.read;
    }
}

