/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.scope.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaValueFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchMultiIndexSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchScopeSearchIndexesContext
implements ElasticsearchSearchIndexesContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final StringToDocumentIdentifierValueConverter RAW_ID_CONVERTER = new StringToDocumentIdentifierValueConverter();
    private final Set<ElasticsearchIndexModel> indexModels;
    private final Set<String> hibernateSearchIndexNames;
    private final Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex;

    public ElasticsearchScopeSearchIndexesContext(Set<ElasticsearchIndexModel> indexModels) {
        this.indexModels = indexModels;
        this.hibernateSearchIndexNames = new LinkedHashSet<String>();
        this.mappedTypeNameToIndex = new LinkedHashMap<String, ElasticsearchSearchIndexContext>();
        for (ElasticsearchIndexModel model : indexModels) {
            this.hibernateSearchIndexNames.add(model.hibernateSearchName());
            this.mappedTypeNameToIndex.put(model.mappedTypeName(), model);
        }
    }

    @Override
    public Collection<ElasticsearchSearchIndexContext> elements() {
        return this.mappedTypeNameToIndex.values();
    }

    @Override
    public Set<String> hibernateSearchIndexNames() {
        return this.hibernateSearchIndexNames;
    }

    @Override
    public Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex() {
        return this.mappedTypeNameToIndex;
    }

    @Override
    public ToDocumentIdentifierValueConverter<?> idDslConverter(ValueConvert valueConvert) {
        if (ValueConvert.NO.equals((Object)valueConvert)) {
            return RAW_ID_CONVERTER;
        }
        ToDocumentIdentifierValueConverter<?> converter = null;
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            ToDocumentIdentifierValueConverter<?> converterForIndex = indexModel.idDslConverter();
            if (converter == null) {
                converter = converterForIndex;
                continue;
            }
            if (converter.isCompatibleWith(converterForIndex)) continue;
            throw log.inconsistentConfigurationForIdentifierForSearch(converter, converterForIndex, this.indexesEventContext());
        }
        return converter;
    }

    @Override
    public ElasticsearchSearchValueFieldContext<?> field(String absoluteFieldPath) {
        ElasticsearchSearchValueFieldContext<Object> resultOrNull = null;
        if (this.indexModels.size() == 1) {
            resultOrNull = this.indexModels.iterator().next().getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
        } else {
            ArrayList fieldForEachIndex = new ArrayList();
            for (ElasticsearchIndexModel indexModel : this.indexModels) {
                ElasticsearchIndexSchemaValueFieldNode<?> fieldForCurrentIndex = indexModel.getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
                if (fieldForCurrentIndex == null) continue;
                fieldForEachIndex.add(fieldForCurrentIndex);
            }
            if (!fieldForEachIndex.isEmpty()) {
                resultOrNull = new ElasticsearchMultiIndexSearchValueFieldContext(this.hibernateSearchIndexNames(), absoluteFieldPath, fieldForEachIndex);
            }
        }
        if (resultOrNull == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.indexesEventContext());
        }
        return resultOrNull;
    }

    @Override
    public boolean hasSchemaObjectNodeComponent(String absoluteFieldPath) {
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            ElasticsearchIndexSchemaObjectFieldNode objectNode = indexModel.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
            if (objectNode == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkNestedField(String absoluteFieldPath) {
        AbstractElasticsearchIndexSchemaFieldNode schemaNode;
        boolean found = false;
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            schemaNode = indexModel.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
            if (schemaNode == null) continue;
            found = true;
            if (ObjectStructure.NESTED.equals((Object)schemaNode.structure())) continue;
            throw log.nonNestedFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
        }
        if (!found) {
            for (ElasticsearchIndexModel indexModel : this.indexModels) {
                schemaNode = indexModel.getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
                if (schemaNode == null) continue;
                throw log.nonObjectFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
            }
            throw log.unknownFieldForSearch(absoluteFieldPath, this.indexesEventContext());
        }
    }

    @Override
    public List<String> nestedPathHierarchyForObject(String absoluteObjectPath) {
        Optional nestedDocumentPath = this.indexModels.stream().map(indexModel -> indexModel.getObjectFieldNode(absoluteObjectPath, IndexFieldFilter.INCLUDED_ONLY)).filter(Objects::nonNull).map(node -> Optional.ofNullable(node.nestedPathHierarchy())).reduce((nestedDocumentPath1, nestedDocumentPath2) -> {
            if (Objects.equals(nestedDocumentPath1, nestedDocumentPath2)) {
                return nestedDocumentPath1;
            }
            throw log.conflictingNestedDocumentPathHierarchy(absoluteObjectPath, nestedDocumentPath1.orElse(null), nestedDocumentPath2.orElse(null), this.indexesEventContext());
        }).orElse(Optional.empty());
        return nestedDocumentPath.orElse(Collections.emptyList());
    }

    private EventContext indexesEventContext() {
        return EventContexts.fromIndexNames(this.hibernateSearchIndexNames());
    }
}

