/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultImpl;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.engine.search.query.SearchScrollResult;
import org.hibernate.search.engine.search.query.spi.SimpleSearchScrollResult;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;

public class ElasticsearchSearchScroll<H>
implements SearchScroll<H> {
    private final ElasticsearchParallelWorkOrchestrator queryOrchestrator;
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor;
    private final String scrollTimeoutString;
    private final NonBulkableWork<ElasticsearchLoadableSearchResult<H>> firstScroll;
    private String scrollId;

    public ElasticsearchSearchScroll(ElasticsearchParallelWorkOrchestrator queryOrchestrator, ElasticsearchWorkBuilderFactory workFactory, ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor, String scrollTimeoutString, NonBulkableWork<ElasticsearchLoadableSearchResult<H>> firstScroll) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchResultExtractor = searchResultExtractor;
        this.scrollTimeoutString = scrollTimeoutString;
        this.firstScroll = firstScroll;
    }

    public void close() {
        if (this.scrollId != null) {
            Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit((NonBulkableWork)this.workFactory.clearScroll(this.scrollId).build()));
        }
    }

    public SearchScrollResult<H> next() {
        NonBulkableWork scroll = this.scrollId == null ? this.firstScroll : (NonBulkableWork)this.workFactory.scroll(this.scrollId, this.scrollTimeoutString, this.searchResultExtractor).build();
        ElasticsearchLoadableSearchResult loadableSearchResult = (ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(scroll));
        ElasticsearchSearchResultImpl searchResult = loadableSearchResult.loadBlocking();
        this.scrollId = searchResult.scrollId();
        if (this.scrollId == null) {
            throw new AssertionFailure("Elasticsearch response lacked a value for scroll id");
        }
        return new SimpleSearchScrollResult(loadableSearchResult.hasHits(), searchResult.hits(), searchResult.took(), Boolean.valueOf(searchResult.timedOut()));
    }
}

