/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.cfg.spi.NumberScaleConstants;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchBigIntegerFieldCodec
implements ElasticsearchFieldCodec<BigInteger> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final int decimalScale;
    private final BigDecimal scalingFactor;

    public ElasticsearchBigIntegerFieldCodec(int decimalScale) {
        this.decimalScale = decimalScale;
        this.scalingFactor = BigDecimal.TEN.pow(decimalScale, new MathContext(10, RoundingMode.HALF_UP));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[decimalScale=" + this.decimalScale + "]";
    }

    @Override
    public JsonElement encode(BigInteger value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (this.isTooLarge(value)) {
            throw log.scaledNumberTooLarge(value);
        }
        return new JsonPrimitive((Number)value);
    }

    @Override
    public BigInteger decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.BIG_INTEGER.fromElement(element);
    }

    @Override
    public BigInteger decodeAggregationKey(JsonElement key, JsonElement keyAsString) {
        if (key == null || key.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.BIG_DECIMAL.fromElement(key).toBigInteger();
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElasticsearchBigIntegerFieldCodec other = (ElasticsearchBigIntegerFieldCodec)obj;
        return this.decimalScale == other.decimalScale;
    }

    public BigDecimal scalingFactor() {
        return this.scalingFactor;
    }

    public boolean isTooLarge(BigInteger value) {
        BigDecimal scaled = new BigDecimal(value).multiply(this.scalingFactor);
        return scaled.compareTo(NumberScaleConstants.MIN_LONG_AS_BIGDECIMAL) < 0 || scaled.compareTo(NumberScaleConstants.MAX_LONG_AS_BIGDECIMAL) > 0;
    }
}

