/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.AbstractElasticsearchCodecAwareSearchFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.spatial.GeoBoundingBox;
import org.hibernate.search.engine.spatial.GeoPoint;

public class ElasticsearchGeoPointSpatialWithinBoundingBoxPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor GEO_BOUNDING_BOX_ACCESSOR = JsonAccessor.root().property("geo_bounding_box").asObject();
    private static final String TOP_LEFT_PROPERTY_NAME = "top_left";
    private static final String BOTTOM_RIGHT_PROPERTY_NAME = "bottom_right";
    private final JsonElement topLeft;
    private final JsonElement bottomRight;

    private ElasticsearchGeoPointSpatialWithinBoundingBoxPredicate(Builder builder) {
        super(builder);
        this.topLeft = builder.topLeft;
        this.bottomRight = builder.bottomRight;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        JsonObject boundingBoxObject = new JsonObject();
        boundingBoxObject.add(TOP_LEFT_PROPERTY_NAME, this.topLeft);
        boundingBoxObject.add(BOTTOM_RIGHT_PROPERTY_NAME, this.bottomRight);
        innerObject.add(this.absoluteFieldPath, (JsonElement)boundingBoxObject);
        GEO_BOUNDING_BOX_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements SpatialWithinBoundingBoxPredicateBuilder {
        private final ElasticsearchFieldCodec<GeoPoint> codec;
        private JsonElement topLeft;
        private JsonElement bottomRight;

        private Builder(ElasticsearchFieldCodec<GeoPoint> codec, ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<GeoPoint> field) {
            super(searchContext, field);
            this.codec = codec;
        }

        public void boundingBox(GeoBoundingBox boundingBox) {
            this.topLeft = this.codec.encode(boundingBox.topLeft());
            this.bottomRight = this.codec.encode(boundingBox.bottomRight());
        }

        public SearchPredicate build() {
            return new ElasticsearchGeoPointSpatialWithinBoundingBoxPredicate(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchCodecAwareSearchFieldQueryElementFactory<SpatialWithinBoundingBoxPredicateBuilder, GeoPoint> {
        public Factory(ElasticsearchFieldCodec<GeoPoint> codec) {
            super(codec);
        }

        @Override
        public Builder create(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<GeoPoint> field) {
            return new Builder(this.codec, searchContext, field);
        }
    }
}

