/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchReversibleSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractElasticsearchDocumentValueSort
extends AbstractElasticsearchReversibleSort {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonElement> NESTED_ACCESSOR = JsonAccessor.root().property("nested");
    private static final JsonAccessor<JsonElement> PATH_ACCESSOR = JsonAccessor.root().property("path");
    private static final JsonAccessor<JsonElement> FILTER_ACCESSOR = JsonAccessor.root().property("filter");
    private static final JsonAccessor<JsonElement> NESTED_PATH_ACCESSOR = JsonAccessor.root().property("nested_path");
    private static final JsonAccessor<JsonElement> NESTED_FILTER_ACCESSOR = JsonAccessor.root().property("nested_filter");
    private static final JsonAccessor<JsonElement> MODE_ACCESSOR = JsonAccessor.root().property("mode");
    private static final JsonPrimitive SUM_KEYWORD_JSON = new JsonPrimitive("sum");
    private static final JsonPrimitive AVG_KEYWORD_JSON = new JsonPrimitive("avg");
    private static final JsonPrimitive MIN_KEYWORD_JSON = new JsonPrimitive("min");
    private static final JsonPrimitive MAX_KEYWORD_JSON = new JsonPrimitive("max");
    private static final JsonPrimitive MEDIAN_KEYWORD_JSON = new JsonPrimitive("median");
    protected final String absoluteFieldPath;
    protected final List<String> nestedPathHierarchy;
    private final ElasticsearchSearchSyntax searchSyntax;
    private final JsonPrimitive mode;
    private final ElasticsearchSearchPredicate filter;

    AbstractElasticsearchDocumentValueSort(AbstractBuilder<?> builder) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.nestedPathHierarchy = builder.nestedPathHierarchy;
        this.searchSyntax = ((AbstractBuilder)builder).searchSyntax;
        this.mode = ((AbstractBuilder)builder).mode;
        this.filter = ((AbstractBuilder)builder).filter;
    }

    @Override
    protected void enrichInnerObject(ElasticsearchSearchSortCollector collector, JsonObject innerObject) {
        if (!this.nestedPathHierarchy.isEmpty()) {
            if (this.searchSyntax.useOldSortNestedApi()) {
                String lastNestedPath = this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1);
                NESTED_PATH_ACCESSOR.set(innerObject, (JsonElement)new JsonPrimitive(lastNestedPath));
                if (this.filter != null) {
                    PredicateRequestContext filterContext = collector.getRootPredicateContext().withNestedPath(lastNestedPath);
                    JsonObject jsonFilter = this.getJsonFilter(filterContext);
                    NESTED_FILTER_ACCESSOR.set(innerObject, (JsonElement)jsonFilter);
                }
            } else {
                JsonObject nextNestedObjectTarget = innerObject;
                for (int i = 0; i < this.nestedPathHierarchy.size(); ++i) {
                    String nestedPath = this.nestedPathHierarchy.get(i);
                    JsonObject nestedObject = new JsonObject();
                    PATH_ACCESSOR.set(nestedObject, (JsonElement)new JsonPrimitive(nestedPath));
                    NESTED_ACCESSOR.set(nextNestedObjectTarget, (JsonElement)nestedObject);
                    if (i == this.nestedPathHierarchy.size() - 1 && this.filter != null) {
                        PredicateRequestContext filterContext = collector.getRootPredicateContext().withNestedPath(nestedPath);
                        JsonObject jsonFilter = this.getJsonFilter(filterContext);
                        FILTER_ACCESSOR.set(nestedObject, (JsonElement)jsonFilter);
                    }
                    nextNestedObjectTarget = nestedObject;
                }
            }
        }
        if (this.mode != null) {
            MODE_ACCESSOR.set(innerObject, (JsonElement)this.mode);
        }
    }

    private JsonObject getJsonFilter(PredicateRequestContext filterContext) {
        return this.filter.toJsonQuery(filterContext);
    }

    static abstract class AbstractBuilder<F>
    extends AbstractElasticsearchReversibleSort.AbstractBuilder {
        private final ElasticsearchSearchSyntax searchSyntax;
        protected final ElasticsearchSearchValueFieldContext<F> field;
        protected final List<String> nestedPathHierarchy;
        private JsonPrimitive mode;
        private ElasticsearchSearchPredicate filter;

        AbstractBuilder(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field) {
            super(searchContext);
            this.searchSyntax = searchContext.searchSyntax();
            this.field = field;
            this.nestedPathHierarchy = field.nestedPathHierarchy();
        }

        public void mode(SortMode mode) {
            if (!this.nestedPathHierarchy.isEmpty() && SortMode.MEDIAN.equals((Object)mode)) {
                throw log.cannotComputeMedianAcrossNested(this.field.eventContext());
            }
            if (mode != null) {
                switch (mode) {
                    case SUM: {
                        this.mode = SUM_KEYWORD_JSON;
                        break;
                    }
                    case AVG: {
                        this.mode = AVG_KEYWORD_JSON;
                        break;
                    }
                    case MIN: {
                        this.mode = MIN_KEYWORD_JSON;
                        break;
                    }
                    case MAX: {
                        this.mode = MAX_KEYWORD_JSON;
                        break;
                    }
                    case MEDIAN: {
                        this.mode = MEDIAN_KEYWORD_JSON;
                        break;
                    }
                    default: {
                        throw new AssertionFailure("Unexpected sort mode: " + mode);
                    }
                }
            }
        }

        public void filter(SearchPredicate filter) {
            if (this.nestedPathHierarchy.isEmpty()) {
                throw log.cannotFilterSortOnRootDocumentField(this.field.absolutePath(), this.field.eventContext());
            }
            ElasticsearchSearchPredicate elasticsearchFilter = ElasticsearchSearchPredicate.from(this.searchContext, filter);
            elasticsearchFilter.checkNestableWithin(this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1));
            this.filter = elasticsearchFilter;
        }
    }
}

