/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.CountWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;

public class CountWork
extends AbstractNonBulkableWork<Long> {
    private static final JsonAccessor<Long> COUNT_ACCESSOR = JsonAccessor.root().property("count").asLong();

    protected CountWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Long generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.body();
        return COUNT_ACCESSOR.get(body).get();
    }

    public static class Builder
    extends AbstractNonBulkableWork.AbstractBuilder<Builder>
    implements CountWorkBuilder {
        private final List<URLEncodedString> indexNames = new ArrayList<URLEncodedString>();
        private JsonObject query;
        private Set<String> routingKeys;
        private Long timeoutValue;
        private TimeUnit timeoutUnit;
        private boolean exceptionOnTimeout;

        public Builder() {
            super(DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
        }

        @Override
        public Builder index(URLEncodedString indexName) {
            this.indexNames.add(indexName);
            return this;
        }

        @Override
        public Builder query(JsonObject query) {
            this.query = query;
            return this;
        }

        @Override
        public Builder routingKeys(Set<String> routingKeys) {
            this.routingKeys = routingKeys;
            return this;
        }

        @Override
        public CountWorkBuilder timeout(Long timeoutValue, TimeUnit timeoutUnit, boolean exceptionOnTimeout) {
            this.timeoutValue = timeoutValue;
            this.timeoutUnit = timeoutUnit;
            this.exceptionOnTimeout = exceptionOnTimeout;
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().multiValuedPathComponent(this.indexNames);
            builder.pathComponent(Paths._COUNT);
            if (this.query != null) {
                builder.body(this.query);
            }
            if (!this.routingKeys.isEmpty()) {
                builder.multiValuedParam("routing", this.routingKeys);
            }
            if (this.exceptionOnTimeout) {
                builder.timeout(this.timeoutValue, this.timeoutUnit);
            }
            return builder.build();
        }

        @Override
        public CountWork build() {
            return new CountWork(this);
        }
    }
}

