/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.cfg;

import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.mapping.TypeNameMappingStrategyName;
import org.hibernate.search.backend.elasticsearch.multitenancy.MultiTenancyStrategyName;

public final class ElasticsearchBackendSettings {
    public static final String TYPE_NAME = "elasticsearch";
    public static final String HOSTS = "hosts";
    public static final String PROTOCOL = "protocol";
    public static final String PATH_PREFIX = "path_prefix";
    public static final String VERSION = "version";
    public static final String VERSION_CHECK_ENABLED = "version_check.enabled";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String REQUEST_TIMEOUT = "request_timeout";
    public static final String READ_TIMEOUT = "read_timeout";
    public static final String CONNECTION_TIMEOUT = "connection_timeout";
    public static final String MAX_CONNECTIONS = "max_connections";
    public static final String MAX_CONNECTIONS_PER_ROUTE = "max_connections_per_route";
    public static final String DISCOVERY_ENABLED = "discovery.enabled";
    public static final String DISCOVERY_REFRESH_INTERVAL = "discovery.refresh_interval";
    public static final String LOG_JSON_PRETTY_PRINTING = "log.json_pretty_printing";
    public static final String MULTI_TENANCY_STRATEGY = "multi_tenancy.strategy";
    public static final String MAPPING_TYPE_NAME_STRATEGY = "mapping.type_name.strategy";
    public static final String LAYOUT_STRATEGY = "layout.strategy";
    public static final String THREAD_POOL_SIZE = "thread_pool.size";
    public static final String SCROLL_TIMEOUT = "scroll_timeout";

    private ElasticsearchBackendSettings() {
    }

    public static final class Defaults {
        public static final List<String> HOSTS = Collections.singletonList("localhost:9200");
        public static final String PROTOCOL = "http";
        public static final String PATH_PREFIX = "";
        public static final int READ_TIMEOUT = 30000;
        public static final int CONNECTION_TIMEOUT = 1000;
        public static final int MAX_CONNECTIONS = 20;
        public static final int MAX_CONNECTIONS_PER_ROUTE = 10;
        public static final boolean DISCOVERY_ENABLED = false;
        public static final int DISCOVERY_REFRESH_INTERVAL = 10;
        public static final boolean LOG_JSON_PRETTY_PRINTING = false;
        public static final boolean VERSION_CHECK_ENABLED = true;
        public static final MultiTenancyStrategyName MULTI_TENANCY_STRATEGY = MultiTenancyStrategyName.NONE;
        public static final TypeNameMappingStrategyName MAPPING_TYPE_NAME_STRATEGY = TypeNameMappingStrategyName.DISCRIMINATOR;
        public static final int SCROLL_TIMEOUT = 60;

        private Defaults() {
        }
    }
}

