/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldReference;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaValueFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexSchemaValueFieldNodeBuilder<F>
implements IndexSchemaFieldOptionsStep<ElasticsearchIndexSchemaValueFieldNodeBuilder<F>, IndexFieldReference<F>>,
ElasticsearchIndexSchemaNodeContributor,
IndexSchemaBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractElasticsearchIndexSchemaObjectNodeBuilder parent;
    private final String relativeFieldName;
    private final String absoluteFieldPath;
    private final IndexFieldInclusion inclusion;
    private final ElasticsearchIndexValueFieldType<F> type;
    private boolean multiValued = false;
    private ElasticsearchIndexFieldReference<F> reference;

    ElasticsearchIndexSchemaValueFieldNodeBuilder(AbstractElasticsearchIndexSchemaObjectNodeBuilder parent, String relativeFieldName, IndexFieldInclusion inclusion, ElasticsearchIndexValueFieldType<F> type) {
        this.parent = parent;
        this.relativeFieldName = relativeFieldName;
        this.absoluteFieldPath = FieldPaths.compose((String)parent.getAbsolutePath(), (String)relativeFieldName);
        this.inclusion = inclusion;
        this.type = type;
    }

    public EventContext eventContext() {
        return this.parent.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public ElasticsearchIndexSchemaValueFieldNodeBuilder<F> multiValued() {
        this.multiValued = true;
        return this;
    }

    public IndexFieldReference<F> toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.eventContext());
        }
        this.reference = new ElasticsearchIndexFieldReference();
        return this.reference;
    }

    @Override
    public void contribute(ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode, Map<String, AbstractElasticsearchIndexSchemaFieldNode> staticChildrenByNameForParent, AbstractTypeMapping parentMapping) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.eventContext());
        }
        ElasticsearchIndexSchemaValueFieldNode<F> fieldNode = new ElasticsearchIndexSchemaValueFieldNode<F>(parentNode, this.relativeFieldName, this.inclusion, this.multiValued, this.type);
        staticChildrenByNameForParent.put(this.relativeFieldName, fieldNode);
        collector.collect(this.absoluteFieldPath, fieldNode);
        if (IndexFieldInclusion.INCLUDED.equals((Object)fieldNode.inclusion())) {
            parentMapping.addProperty(this.relativeFieldName, this.type.mapping());
        }
        this.reference.setSchemaNode(fieldNode);
    }
}

