/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.scope.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchMultiIndexSearchObjectFieldContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchMultiIndexSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchFieldContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchObjectFieldContext;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchScopeSearchIndexesContext
implements ElasticsearchSearchIndexesContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final StringToDocumentIdentifierValueConverter RAW_ID_CONVERTER = new StringToDocumentIdentifierValueConverter();
    private final Set<ElasticsearchIndexModel> indexModels;
    private final Set<String> hibernateSearchIndexNames;
    private final Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex;

    public ElasticsearchScopeSearchIndexesContext(Set<ElasticsearchIndexModel> indexModels) {
        this.indexModels = indexModels;
        this.hibernateSearchIndexNames = new LinkedHashSet<String>();
        this.mappedTypeNameToIndex = new LinkedHashMap<String, ElasticsearchSearchIndexContext>();
        for (ElasticsearchIndexModel model : indexModels) {
            this.hibernateSearchIndexNames.add(model.hibernateSearchName());
            this.mappedTypeNameToIndex.put(model.mappedTypeName(), model);
        }
    }

    @Override
    public Collection<ElasticsearchSearchIndexContext> elements() {
        return this.mappedTypeNameToIndex.values();
    }

    @Override
    public Set<String> hibernateSearchIndexNames() {
        return this.hibernateSearchIndexNames;
    }

    @Override
    public Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex() {
        return this.mappedTypeNameToIndex;
    }

    @Override
    public ToDocumentIdentifierValueConverter<?> idDslConverter(ValueConvert valueConvert) {
        if (ValueConvert.NO.equals((Object)valueConvert)) {
            return RAW_ID_CONVERTER;
        }
        ToDocumentIdentifierValueConverter<?> converter = null;
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            ToDocumentIdentifierValueConverter<?> converterForIndex = indexModel.idDslConverter();
            if (converter == null) {
                converter = converterForIndex;
                continue;
            }
            if (converter.isCompatibleWith(converterForIndex)) continue;
            throw log.inconsistentConfigurationForIdentifierForSearch(converter, converterForIndex, this.indexesEventContext());
        }
        return converter;
    }

    @Override
    public ElasticsearchSearchFieldContext field(String absoluteFieldPath) {
        ElasticsearchSearchFieldContext resultOrNull = this.elements().size() == 1 ? this.indexModels.iterator().next().fieldOrNull(absoluteFieldPath) : this.createMultiIndexFieldContext(absoluteFieldPath);
        if (resultOrNull == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.indexesEventContext());
        }
        return resultOrNull;
    }

    @Override
    public boolean hasSchemaObjectNodeComponent(String absoluteFieldPath) {
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            AbstractElasticsearchIndexSchemaFieldNode field = indexModel.fieldOrNull(absoluteFieldPath);
            if (field == null || !field.isObjectField()) continue;
            return true;
        }
        return false;
    }

    private EventContext indexesEventContext() {
        return EventContexts.fromIndexNames(this.hibernateSearchIndexNames());
    }

    private ElasticsearchSearchFieldContext createMultiIndexFieldContext(String absoluteFieldPath) {
        ArrayList<ElasticsearchSearchObjectFieldContext> fieldForEachIndex = new ArrayList<ElasticsearchSearchObjectFieldContext>();
        ElasticsearchIndexModel indexModelOfFirstField = null;
        AbstractElasticsearchIndexSchemaFieldNode firstField = null;
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            AbstractElasticsearchIndexSchemaFieldNode fieldForCurrentIndex = indexModel.fieldOrNull(absoluteFieldPath);
            if (fieldForCurrentIndex == null) continue;
            if (firstField == null) {
                indexModelOfFirstField = indexModel;
                firstField = fieldForCurrentIndex;
            } else if (firstField.isObjectField() != fieldForCurrentIndex.isObjectField()) {
                SearchException cause = log.conflictingFieldModel();
                throw log.inconsistentConfigurationForFieldForSearch(absoluteFieldPath, cause.getMessage(), EventContexts.fromIndexNames((String[])new String[]{indexModelOfFirstField.names().getHibernateSearch(), indexModel.names().getHibernateSearch()}), cause);
            }
            fieldForEachIndex.add((ElasticsearchSearchObjectFieldContext)((Object)fieldForCurrentIndex));
        }
        if (fieldForEachIndex.isEmpty()) {
            return null;
        }
        if (((ElasticsearchSearchFieldContext)fieldForEachIndex.get(0)).isObjectField()) {
            return new ElasticsearchMultiIndexSearchObjectFieldContext(this.hibernateSearchIndexNames, absoluteFieldPath, fieldForEachIndex);
        }
        return new ElasticsearchMultiIndexSearchValueFieldContext(this.hibernateSearchIndexNames, absoluteFieldPath, fieldForEachIndex);
    }
}

