/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregationCollector;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchUserProvidedJsonAggregation;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilderFactory;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSearchAggregationBuilderFactory
implements SearchAggregationBuilderFactory<ElasticsearchSearchAggregationCollector> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchSearchIndexesContext indexes;

    public ElasticsearchSearchAggregationBuilderFactory(ElasticsearchSearchContext searchContext) {
        this.searchContext = searchContext;
        this.indexes = searchContext.indexes();
    }

    public <A> void contribute(ElasticsearchSearchAggregationCollector collector, AggregationKey<A> key, SearchAggregation<A> aggregation) {
        if (!(aggregation instanceof ElasticsearchSearchAggregation)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherAggregations(aggregation);
        }
        ElasticsearchSearchAggregation casted = (ElasticsearchSearchAggregation)aggregation;
        if (!this.indexes.hibernateSearchIndexNames().equals(casted.getIndexNames())) {
            throw log.aggregationDefinedOnDifferentIndexes(aggregation, casted.getIndexNames(), this.indexes.hibernateSearchIndexNames());
        }
        collector.collectAggregation(key, casted);
    }

    public <T> TermsAggregationBuilder<T> createTermsAggregationBuilder(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        return this.indexes.field(absoluteFieldPath).queryElement(AggregationTypeKeys.TERMS, this.searchContext).type(expectedType, convert);
    }

    public <T> RangeAggregationBuilder<T> createRangeAggregationBuilder(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        return this.indexes.field(absoluteFieldPath).queryElement(AggregationTypeKeys.RANGE, this.searchContext).type(expectedType, convert);
    }

    public SearchAggregationBuilder<JsonObject> fromJson(JsonObject jsonObject) {
        return new ElasticsearchUserProvidedJsonAggregation.Builder(this.searchContext, jsonObject);
    }

    public SearchAggregationBuilder<JsonObject> fromJson(String jsonString) {
        return this.fromJson((JsonObject)this.searchContext.userFacingGson().fromJson(jsonString, JsonObject.class));
    }
}

