/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchNestablePredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchPredicate;

public abstract class AbstractElasticsearchSingleFieldPredicate
extends AbstractElasticsearchNestablePredicate {
    protected final String absoluteFieldPath;
    private final List<String> nestedPathHierarchy;

    protected AbstractElasticsearchSingleFieldPredicate(AbstractBuilder builder) {
        super(builder);
        this.absoluteFieldPath = builder.absoluteFieldPath;
        this.nestedPathHierarchy = builder.nestedPathHierarchy;
    }

    @Override
    protected List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    protected List<String> getFieldPathsForErrorMessage() {
        return Collections.singletonList(this.absoluteFieldPath);
    }

    protected static abstract class AbstractBuilder
    extends AbstractElasticsearchPredicate.AbstractBuilder {
        protected final String absoluteFieldPath;
        private final List<String> nestedPathHierarchy;

        protected AbstractBuilder(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<?> field) {
            this(searchContext, field.absolutePath(), field.nestedPathHierarchy());
        }

        protected AbstractBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy) {
            super(searchContext);
            this.absoluteFieldPath = absoluteFieldPath;
            this.nestedPathHierarchy = nestedPathHierarchy;
        }
    }
}

