/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.ScoreProjectionBuilder;

class ElasticsearchScoreProjection
extends AbstractElasticsearchProjection<Float, Float> {
    private static final JsonAccessor<Boolean> TRACK_SCORES_ACCESSOR = JsonAccessor.root().property("track_scores").asBoolean();

    private ElasticsearchScoreProjection(ElasticsearchSearchContext searchContext) {
        super(searchContext);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        TRACK_SCORES_ACCESSOR.set(requestBody, true);
    }

    @Override
    public Float extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, SearchProjectionExtractContext context) {
        return Float.valueOf(hit.get("_score").getAsFloat());
    }

    @Override
    public Float transform(LoadingResult<?, ?> loadingResult, Float extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    static class Builder
    extends AbstractElasticsearchProjection.AbstractBuilder<Float>
    implements ScoreProjectionBuilder {
        private final ElasticsearchScoreProjection projection;

        Builder(ElasticsearchSearchContext searchContext) {
            super(searchContext);
            this.projection = new ElasticsearchScoreProjection(searchContext);
        }

        public SearchProjection<Float> build() {
            return this.projection;
        }
    }
}

