/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public interface ElasticsearchSearchSort
extends SearchSort {
    public static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public Set<String> indexNames();

    public void toJsonSorts(ElasticsearchSearchSortCollector var1);

    public static ElasticsearchSearchSort from(ElasticsearchSearchContext searchContext, SearchSort sort) {
        if (!(sort instanceof ElasticsearchSearchSort)) {
            throw log.cannotMixElasticsearchSearchSortWithOtherSorts(sort);
        }
        ElasticsearchSearchSort casted = (ElasticsearchSearchSort)sort;
        if (!searchContext.indexes().hibernateSearchIndexNames().equals(casted.indexNames())) {
            throw log.sortDefinedOnDifferentIndexes(sort, casted.indexNames(), searchContext.indexes().hibernateSearchIndexNames());
        }
        return casted;
    }
}

