/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchTermsAggregation;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchExistsPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchRangePredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.SortTypeKeys;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchBooleanFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchSimpleStandardFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardMatchPredicate;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSort;

class ElasticsearchBooleanIndexFieldTypeOptionsStep
extends AbstractElasticsearchSimpleStandardFieldTypeOptionsStep<ElasticsearchBooleanIndexFieldTypeOptionsStep, Boolean> {
    ElasticsearchBooleanIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Boolean.class, "boolean");
    }

    @Override
    protected void complete() {
        ElasticsearchBooleanFieldCodec codec = ElasticsearchBooleanFieldCodec.INSTANCE;
        this.builder.codec(codec);
        if (this.resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.MATCH, new ElasticsearchStandardMatchPredicate.Factory<Boolean>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.RANGE, new ElasticsearchRangePredicate.Factory<Boolean>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, new ElasticsearchExistsPredicate.Factory());
        }
        if (this.resolvedSortable) {
            this.builder.sortable(true);
            this.builder.queryElementFactory(SortTypeKeys.FIELD, new ElasticsearchStandardFieldSort.Factory<Boolean>(codec));
        }
        if (this.resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new ElasticsearchFieldProjection.Factory<Boolean>(codec));
        }
        if (this.resolvedAggregable) {
            this.builder.aggregable(true);
            this.builder.queryElementFactory(AggregationTypeKeys.TERMS, new ElasticsearchTermsAggregation.Factory<Boolean>(codec));
        }
    }

    @Override
    protected ElasticsearchBooleanIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

