/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.entity.ContentType;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientUtils;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.spi.JsonLogHelper;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchLogCategories;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.common.timing.spi.Deadline;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LogCategory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchClientImpl
implements ElasticsearchClientImplementor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Log requestLog = (Log)LoggerFactory.make(Log.class, (LogCategory)ElasticsearchLogCategories.REQUEST);
    private final RestClient restClient;
    private final Sniffer sniffer;
    private final ScheduledExecutorService timeoutExecutorService;
    private final Optional<Integer> requestTimeoutMs;
    private final int connectionTimeoutMs;
    private final Gson gson;
    private final JsonLogHelper jsonLogHelper;

    ElasticsearchClientImpl(RestClient restClient, Sniffer sniffer, ScheduledExecutorService timeoutExecutorService, Optional<Integer> requestTimeoutMs, int connectionTimeoutMs, Gson gson, JsonLogHelper jsonLogHelper) {
        this.restClient = restClient;
        this.sniffer = sniffer;
        this.timeoutExecutorService = timeoutExecutorService;
        this.requestTimeoutMs = requestTimeoutMs;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.gson = gson;
        this.jsonLogHelper = jsonLogHelper;
    }

    @Override
    public CompletableFuture<ElasticsearchResponse> submit(ElasticsearchRequest request) {
        CompletionStage result = Futures.create(() -> this.send(request)).thenApply(this::convertResponse);
        if (requestLog.isDebugEnabled()) {
            long startTime = System.nanoTime();
            ((CompletableFuture)result).thenAccept(response -> this.log(request, startTime, (ElasticsearchResponse)response));
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> clientClass) {
        if (RestClient.class.isAssignableFrom(clientClass)) {
            return (T)this.restClient;
        }
        throw log.clientUnwrappingWithUnkownType(clientClass, RestClient.class);
    }

    private CompletableFuture<Response> send(ElasticsearchRequest elasticsearchRequest) {
        HttpEntity entity;
        final CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        try {
            entity = ElasticsearchClientUtils.toEntity(this.gson, elasticsearchRequest);
        }
        catch (IOException | RuntimeException e) {
            completableFuture.completeExceptionally(e);
            return completableFuture;
        }
        this.restClient.performRequestAsync(this.toRequest(elasticsearchRequest, entity), new ResponseListener(){

            public void onSuccess(Response response) {
                completableFuture.complete(response);
            }

            public void onFailure(Exception exception) {
                if (exception instanceof ResponseException) {
                    completableFuture.complete(((ResponseException)exception).getResponse());
                } else {
                    completableFuture.completeExceptionally(exception);
                }
            }
        });
        Deadline deadline = elasticsearchRequest.deadline();
        if (deadline == null && !this.requestTimeoutMs.isPresent()) {
            return completableFuture;
        }
        long currentTimeoutValue = deadline == null ? Long.valueOf(this.requestTimeoutMs.get().intValue()).longValue() : deadline.remainingTimeMillis();
        ScheduledFuture<?> timeout = this.timeoutExecutorService.schedule(() -> {
            if (!completableFuture.isDone()) {
                SearchTimeoutException cause = log.requestTimedOut(Duration.ofNanos(TimeUnit.MILLISECONDS.toNanos(currentTimeoutValue)), elasticsearchRequest);
                completableFuture.completeExceptionally((Throwable)(deadline != null ? deadline.forceTimeoutAndCreateException((Exception)cause) : cause));
            }
        }, currentTimeoutValue, TimeUnit.MILLISECONDS);
        completableFuture.thenRun(() -> timeout.cancel(false));
        return completableFuture;
    }

    private Request toRequest(ElasticsearchRequest elasticsearchRequest, HttpEntity entity) {
        Request request = new Request(elasticsearchRequest.method(), elasticsearchRequest.path());
        this.setPerRequestSocketTimeout(elasticsearchRequest, request);
        for (Map.Entry<String, String> parameter : elasticsearchRequest.parameters().entrySet()) {
            request.addParameter(parameter.getKey(), parameter.getValue());
        }
        request.setEntity(entity);
        return request;
    }

    private void setPerRequestSocketTimeout(ElasticsearchRequest elasticsearchRequest, Request request) {
        Deadline deadline = elasticsearchRequest.deadline();
        if (deadline == null) {
            return;
        }
        long timeToHardTimeout = deadline.remainingTimeMillis();
        int socketTimeoutMs = timeToHardTimeout <= Integer.MAX_VALUE ? Math.toIntExact(timeToHardTimeout) : -1;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(0).setSocketTimeout(socketTimeoutMs).setConnectTimeout(this.connectionTimeoutMs).build();
        RequestOptions.Builder requestOptions = RequestOptions.DEFAULT.toBuilder().setRequestConfig(requestConfig);
        request.setOptions(requestOptions);
    }

    private ElasticsearchResponse convertResponse(Response response) {
        try {
            JsonObject body = this.parseBody(response);
            return new ElasticsearchResponse(response.getHost(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), body);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToParseElasticsearchResponse(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), e.getMessage(), e);
        }
    }

    private JsonObject parseBody(Response response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        Charset charset = ElasticsearchClientImpl.getCharset(entity);
        try (InputStream inputStream = entity.getContent();){
            JsonObject jsonObject;
            try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
                jsonObject = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
            }
            return jsonObject;
        }
    }

    private static Charset getCharset(HttpEntity entity) {
        ContentType contentType = ContentType.get((HttpEntity)entity);
        Charset charset = contentType.getCharset();
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    private void log(ElasticsearchRequest request, long start, ElasticsearchResponse response) {
        boolean successCode = ElasticsearchClientUtils.isSuccessCode(response.statusCode());
        if (!requestLog.isTraceEnabled() && successCode) {
            return;
        }
        long executionTimeNs = System.nanoTime() - start;
        long executionTimeMs = TimeUnit.NANOSECONDS.toMillis(executionTimeNs);
        if (successCode) {
            requestLog.executedRequest(request.method(), response.host(), request.path(), request.parameters(), request.bodyParts().size(), executionTimeMs, response.statusCode(), response.statusMessage(), this.jsonLogHelper.toString(request.bodyParts()), this.jsonLogHelper.toString(response.body()));
        } else {
            requestLog.executedRequestWithFailure(request.method(), response.host(), request.path(), request.parameters(), request.bodyParts().size(), executionTimeMs, response.statusCode(), response.statusMessage(), this.jsonLogHelper.toString(request.bodyParts()), this.jsonLogHelper.toString(response.body()));
        }
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(Sniffer::close, (Object)this.sniffer);
            closer.push(RestClient::close, (Object)this.restClient);
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToShutdownClient(e.getMessage(), e);
        }
    }
}

