/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.hibernate.search.backend.elasticsearch.client.impl.ByteBufferContentEncoder;
import org.hibernate.search.backend.elasticsearch.client.impl.StubIOControl;

final class HttpAsyncContentProducerInputStream
extends InputStream {
    private final HttpAsyncContentProducer contentProducer;
    private final ByteBuffer buffer;
    private final ContentEncoder contentEncoder;

    public HttpAsyncContentProducerInputStream(HttpAsyncContentProducer contentProducer, int bufferSize) {
        this.contentProducer = contentProducer;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.limit(0);
        this.contentEncoder = new ByteBufferContentEncoder(this.buffer);
    }

    @Override
    public int read() throws IOException {
        int read = this.readFromBuffer();
        if (read < 0 && !this.contentEncoder.isCompleted()) {
            this.writeToBuffer();
            read = this.readFromBuffer();
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        int offset = off;
        for (int length = len; length > 0 && !this.contentEncoder.isCompleted(); length -= bytesRead) {
            bytesRead = this.readFromBuffer(b, offset, length);
            if (bytesRead == 0) {
                this.writeToBuffer();
                bytesRead = this.readFromBuffer(b, offset, length);
            }
            offset += bytesRead;
        }
        int totalBytesRead = offset - off;
        if (totalBytesRead == 0 && this.contentEncoder.isCompleted()) {
            return -1;
        }
        return totalBytesRead;
    }

    @Override
    public void close() throws IOException {
        this.contentProducer.close();
    }

    private void writeToBuffer() throws IOException {
        this.buffer.clear();
        this.contentProducer.produceContent(this.contentEncoder, (IOControl)StubIOControl.INSTANCE);
        this.buffer.flip();
    }

    private int readFromBuffer() {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get();
        }
        return -1;
    }

    private int readFromBuffer(byte[] bytes, int offset, int length) {
        int toRead = Math.min(this.buffer.remaining(), length);
        if (toRead > 0) {
            this.buffer.get(bytes, offset, toRead);
        }
        return toRead;
    }
}

