/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;

class ElasticsearchSourceProjection
extends AbstractElasticsearchProjection<JsonObject, JsonObject> {
    private static final JsonArrayAccessor REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asArray();
    private static final JsonObjectAccessor HIT_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asObject();
    private static final JsonPrimitive WILDCARD_ALL = new JsonPrimitive("*");

    private ElasticsearchSourceProjection(ElasticsearchSearchContext searchContext) {
        super(searchContext);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        REQUEST_SOURCE_ACCESSOR.addElementIfAbsent(requestBody, (JsonElement)WILDCARD_ALL);
    }

    @Override
    public JsonObject extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, SearchProjectionExtractContext context) {
        Optional sourceElement = HIT_SOURCE_ACCESSOR.get(hit);
        if (sourceElement.isPresent()) {
            return (JsonObject)sourceElement.get();
        }
        return null;
    }

    @Override
    public JsonObject transform(LoadingResult<?, ?> loadingResult, JsonObject extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    static class Builder
    extends AbstractElasticsearchProjection.AbstractBuilder<JsonObject> {
        private final ElasticsearchSourceProjection projection;

        Builder(ElasticsearchSearchContext searchContext) {
            super(searchContext);
            this.projection = new ElasticsearchSourceProjection(searchContext);
        }

        public SearchProjection<JsonObject> build() {
            return this.projection;
        }
    }
}

