/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexContext;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchRequestTransformer;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchScroll;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchRequestTransformerContextImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchScrollImpl;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.CountWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.SearchWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExplainResult;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.engine.search.query.spi.AbstractSearchQuery;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSearchQueryImpl<H>
extends AbstractSearchQuery<H, ElasticsearchSearchResult<H>>
implements ElasticsearchSearchQuery<H> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final int MAX_RESULT_WINDOW_SIZE = 10000;
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchParallelWorkOrchestrator queryOrchestrator;
    private final ElasticsearchSearchContext searchContext;
    private final BackendSessionContext sessionContext;
    private final LoadingContext<?, ?> loadingContext;
    private final Set<String> routingKeys;
    private final JsonObject payload;
    private final ElasticsearchSearchRequestTransformer requestTransformer;
    private final ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor;
    private final Integer scrollTimeout;
    private final Long totalHitCountThreshold;
    private TimeoutManager timeoutManager;

    ElasticsearchSearchQueryImpl(ElasticsearchWorkBuilderFactory workFactory, ElasticsearchParallelWorkOrchestrator queryOrchestrator, ElasticsearchSearchContext searchContext, BackendSessionContext sessionContext, LoadingContext<?, ?> loadingContext, Set<String> routingKeys, JsonObject payload, ElasticsearchSearchRequestTransformer requestTransformer, ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor, TimeoutManager timeoutManager, Integer scrollTimeout, Long totalHitCountThreshold) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.routingKeys = routingKeys;
        this.payload = payload;
        this.requestTransformer = requestTransformer;
        this.searchResultExtractor = searchResultExtractor;
        this.timeoutManager = timeoutManager;
        this.scrollTimeout = scrollTimeout;
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    public String queryString() {
        return this.payload.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.queryString() + "]";
    }

    public <Q> Q extension(SearchQueryExtension<Q, H> extension) {
        return (Q)DslExtensionState.returnIfSupported(extension, (Optional)extension.extendOptional((SearchQuery)this, this.loadingContext));
    }

    public ElasticsearchSearchResult<H> fetch(Integer offset, Integer limit) {
        this.timeoutManager.start();
        NonBulkableWork work = (NonBulkableWork)this.searchWorkBuilder().paging(this.defaultedLimit(limit, offset), offset).totalHitCountThreshold(this.totalHitCountThreshold).build();
        ElasticsearchSearchResultImpl result = ((ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work))).loadBlocking();
        this.timeoutManager.stop();
        return result;
    }

    public List<H> fetchHits(Integer offset, Integer limit) {
        this.timeoutManager.start();
        NonBulkableWork work = (NonBulkableWork)this.searchWorkBuilder().paging(this.defaultedLimit(limit, offset), offset).disableTrackTotalHits().build();
        ElasticsearchSearchResultImpl result = ((ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work))).loadBlocking();
        this.timeoutManager.stop();
        return result.hits();
    }

    public long fetchTotalHitCount() {
        this.timeoutManager.start();
        JsonObject filteredPayload = new JsonObject();
        Optional querySubTree = JsonAccessor.root().property("query").asObject().get(this.payload);
        if (querySubTree.isPresent()) {
            filteredPayload.add("query", (JsonElement)querySubTree.get());
        }
        CountWorkBuilder builder = this.workFactory.count();
        for (ElasticsearchSearchIndexContext index : this.searchContext.indexes().elements()) {
            builder.index(index.names().read());
        }
        builder.query(filteredPayload).routingKeys(this.routingKeys).deadline(this.timeoutManager.hardDeadlineOrNull()).requestTransformer(ElasticsearchSearchRequestTransformerContextImpl.createTransformerFunction(this.requestTransformer));
        NonBulkableWork work = (NonBulkableWork)builder.build();
        Long result = (Long)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work));
        this.timeoutManager.stop();
        return result;
    }

    public ElasticsearchSearchScroll<H> scroll(int chunkSize) {
        String scrollTimeoutString = this.scrollTimeout + "s";
        SearchWorkBuilder<ElasticsearchLoadableSearchResult<H>> firstScroll = this.searchWorkBuilder().scrolling(chunkSize, scrollTimeoutString);
        return new ElasticsearchSearchScrollImpl<H>(this.queryOrchestrator, this.workFactory, this.searchResultExtractor, scrollTimeoutString, firstScroll, this.timeoutManager);
    }

    @Override
    public JsonObject explain(Object id) {
        Contracts.assertNotNull((Object)id, (String)"id");
        Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex = this.searchContext.indexes().mappedTypeNameToIndex();
        if (mappedTypeNameToIndex.size() != 1) {
            throw log.explainRequiresTypeName(mappedTypeNameToIndex.keySet());
        }
        return this.doExplain(mappedTypeNameToIndex.values().iterator().next(), id);
    }

    @Override
    public JsonObject explain(String typeName, Object id) {
        Contracts.assertNotNull((Object)typeName, (String)"typeName");
        Contracts.assertNotNull((Object)id, (String)"id");
        Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex = this.searchContext.indexes().mappedTypeNameToIndex();
        ElasticsearchSearchIndexContext index = mappedTypeNameToIndex.get(typeName);
        if (index == null) {
            throw log.explainRequiresTypeTargetedByQuery(mappedTypeNameToIndex.keySet(), typeName);
        }
        return this.doExplain(index, id);
    }

    private SearchWorkBuilder<ElasticsearchLoadableSearchResult<H>> searchWorkBuilder() {
        SearchWorkBuilder<ElasticsearchLoadableSearchResult<H>> builder = this.workFactory.search(this.payload, this.searchResultExtractor);
        for (ElasticsearchSearchIndexContext index : this.searchContext.indexes().elements()) {
            builder.index(index.names().read());
        }
        builder.routingKeys(this.routingKeys).deadline(this.timeoutManager.deadlineOrNull(), this.timeoutManager.hasHardTimeout()).requestTransformer(ElasticsearchSearchRequestTransformerContextImpl.createTransformerFunction(this.requestTransformer));
        return builder;
    }

    private Integer defaultedLimit(Integer limit, Integer offset) {
        if (limit != null) {
            return limit;
        }
        int maxLimitThatElasticsearchWillAccept = 10000;
        if (offset != null) {
            maxLimitThatElasticsearchWillAccept -= offset.intValue();
        }
        return maxLimitThatElasticsearchWillAccept;
    }

    private JsonObject doExplain(ElasticsearchSearchIndexContext index, Object id) {
        JsonObject queryOnlyPayload = new JsonObject();
        JsonElement query = this.payload.get("query");
        if (query != null) {
            queryOnlyPayload.add("query", query);
        }
        URLEncodedString elasticsearchId = this.toElasticsearchId(index, id);
        URLEncodedString indexName = index.names().read();
        NonBulkableWork work = (NonBulkableWork)this.workFactory.explain(indexName, elasticsearchId, queryOnlyPayload).routingKeys(this.routingKeys).requestTransformer(ElasticsearchSearchRequestTransformerContextImpl.createTransformerFunction(this.requestTransformer)).build();
        ExplainResult explainResult = (ExplainResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work));
        return explainResult.getJsonObject();
    }

    private URLEncodedString toElasticsearchId(ElasticsearchSearchIndexContext index, Object id) {
        ToDocumentIdentifierValueConverter<?> converter = index.idDslConverter();
        ToDocumentIdentifierValueConvertContext convertContext = this.searchContext.toDocumentIdentifierValueConvertContext();
        String documentId = converter.convertUnknown(id, convertContext);
        return URLEncodedString.fromString(this.searchContext.documentIdHelper().toElasticsearchId(this.sessionContext.tenantIdentifier(), documentId));
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutManager = this.searchContext.createTimeoutManager(timeout, timeUnit, true);
    }
}

