/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public class ElasticsearchByteFieldCodec
implements ElasticsearchFieldCodec<Byte> {
    public static final ElasticsearchByteFieldCodec INSTANCE = new ElasticsearchByteFieldCodec();

    private ElasticsearchByteFieldCodec() {
    }

    @Override
    public JsonElement encode(Byte value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Byte decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.BYTE.fromElement(element);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return INSTANCE == other;
    }
}

