/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.DynamicTemplate;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.NamedDynamicTemplate;
import org.hibernate.search.backend.elasticsearch.validation.impl.DynamicTemplateValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;

public class NamedDynamicTemplateListValidator
implements Validator<List<NamedDynamicTemplate>> {
    private final DynamicTemplateValidator dynamicTemplateValidator = new DynamicTemplateValidator();

    @Override
    public void validate(ValidationErrorCollector errorCollector, List<NamedDynamicTemplate> expected, List<NamedDynamicTemplate> actual) {
        if (expected == null) {
            expected = Collections.emptyList();
        }
        if (actual == null) {
            actual = Collections.emptyList();
        }
        Map<String, DynamicTemplate> expectedAsMap = this.toMapReportingDuplicates(errorCollector, expected);
        Map<String, DynamicTemplate> actualAsMap = this.toMapReportingDuplicates(errorCollector, actual);
        this.dynamicTemplateValidator.validateAllIncludingUnexpected(errorCollector, ValidationContextType.DYNAMIC_TEMPLATE, expectedAsMap, actualAsMap);
        List<String> expectedNamesInOrder = expected.stream().map(NamedDynamicTemplate::getName).collect(Collectors.toList());
        List<String> actualNamesInOrder = actual.stream().map(NamedDynamicTemplate::getName).collect(Collectors.toList());
        actualNamesInOrder.retainAll(expectedNamesInOrder);
        if (actualNamesInOrder.containsAll(expectedNamesInOrder) && actualNamesInOrder.size() == expectedNamesInOrder.size() && !actualNamesInOrder.equals(expectedNamesInOrder)) {
            errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.dynamicTemplatesInvalidOrder(expectedNamesInOrder, actualNamesInOrder));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DynamicTemplate> toMapReportingDuplicates(ValidationErrorCollector errorCollector, List<NamedDynamicTemplate> list) {
        LinkedHashMap<String, DynamicTemplate> result = new LinkedHashMap<String, DynamicTemplate>();
        for (NamedDynamicTemplate template : list) {
            DynamicTemplate previous = result.putIfAbsent(template.getName(), template.getTemplate());
            if (previous == null) continue;
            errorCollector.push(ValidationContextType.DYNAMIC_TEMPLATE, template.getName());
            try {
                errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.dynamicTemplateDuplicate());
            }
            finally {
                errorCollector.pop();
            }
        }
        return result;
    }
}

