/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchVersion {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Pattern pattern = Pattern.compile("(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(?:-(\\w+))?)?)?");
    private final int major;
    private final Integer minor;
    private final Integer micro;
    private final String qualifier;

    public static ElasticsearchVersion of(String versionString) {
        String normalizedVersion = versionString.trim().toLowerCase(Locale.ROOT);
        Matcher matcher = pattern.matcher(normalizedVersion);
        if (!matcher.matches()) {
            throw log.invalidElasticsearchVersion(normalizedVersion);
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        String micro = matcher.group(3);
        String qualifier = matcher.group(4);
        return new ElasticsearchVersion(Integer.parseInt(major), minor == null ? null : Integer.valueOf(Integer.parseInt(minor)), micro == null ? null : Integer.valueOf(Integer.parseInt(micro)), qualifier);
    }

    private ElasticsearchVersion(int major, Integer minor, Integer micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major);
        if (this.minor != null) {
            builder.append(".").append(this.minor);
        }
        if (this.micro != null) {
            builder.append(".").append(this.micro);
        }
        if (this.qualifier != null) {
            builder.append("-").append(this.qualifier);
        }
        return builder.toString();
    }

    public int major() {
        return this.major;
    }

    public OptionalInt minor() {
        return this.minor == null ? OptionalInt.empty() : OptionalInt.of(this.minor);
    }

    public OptionalInt micro() {
        return this.micro == null ? OptionalInt.empty() : OptionalInt.of(this.micro);
    }

    public Optional<String> qualifier() {
        return Optional.ofNullable(this.qualifier);
    }

    public boolean matches(ElasticsearchVersion other) {
        return !(this.major != other.major || this.minor != null && !this.minor.equals(other.minor) || this.micro != null && !this.micro.equals(other.micro) || this.qualifier != null && !this.qualifier.equals(other.qualifier));
    }
}

