/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldTemplate;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.lowlevel.impl.LowLevelIndexMetadataBuilder;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.metamodel.ElasticsearchIndexDescriptor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexModel
implements ElasticsearchIndexDescriptor,
ElasticsearchSearchIndexContext {
    private final IndexNames names;
    private final String mappedTypeName;
    private final EventContext eventContext;
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final RootTypeMapping mapping;
    private final ToDocumentIdentifierValueConverter<?> idDslConverter;
    private final ElasticsearchIndexSchemaObjectNode rootNode;
    private final Map<String, AbstractElasticsearchIndexSchemaFieldNode> staticFields;
    private final List<IndexFieldDescriptor> includedStaticFields;
    private final List<AbstractElasticsearchIndexSchemaFieldTemplate<?>> fieldTemplates;
    private final ConcurrentMap<String, AbstractElasticsearchIndexSchemaFieldNode> dynamicFieldsCache = new ConcurrentHashMap<String, AbstractElasticsearchIndexSchemaFieldNode>();

    public ElasticsearchIndexModel(IndexNames names, String mappedTypeName, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, RootTypeMapping mapping, ToDocumentIdentifierValueConverter<?> idDslConverter, ElasticsearchIndexSchemaObjectNode rootNode, Map<String, AbstractElasticsearchIndexSchemaFieldNode> staticFields, List<AbstractElasticsearchIndexSchemaFieldTemplate<?>> fieldTemplates) {
        this.names = names;
        this.mappedTypeName = mappedTypeName;
        this.eventContext = EventContexts.fromIndexName((String)this.hibernateSearchName());
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.mapping = mapping;
        this.idDslConverter = idDslConverter;
        this.rootNode = rootNode;
        this.staticFields = staticFields;
        this.includedStaticFields = CollectionHelper.toImmutableList(staticFields.values().stream().filter(field -> IndexFieldInclusion.INCLUDED.equals((Object)field.inclusion())).collect(Collectors.toList()));
        this.fieldTemplates = fieldTemplates;
    }

    public String hibernateSearchName() {
        return this.names.hibernateSearchIndex();
    }

    @Override
    public IndexNames names() {
        return this.names;
    }

    @Override
    public String mappedTypeName() {
        return this.mappedTypeName;
    }

    @Override
    public ToDocumentIdentifierValueConverter<?> idDslConverter() {
        return this.idDslConverter;
    }

    public ElasticsearchIndexSchemaObjectNode root() {
        return this.rootNode;
    }

    public Optional<IndexFieldDescriptor> field(String absolutePath) {
        return Optional.ofNullable(this.fieldOrNull(absolutePath));
    }

    public AbstractElasticsearchIndexSchemaFieldNode fieldOrNull(String absolutePath) {
        return this.fieldOrNull(absolutePath, IndexFieldFilter.INCLUDED_ONLY);
    }

    public AbstractElasticsearchIndexSchemaFieldNode fieldOrNull(String absolutePath, IndexFieldFilter filter) {
        AbstractElasticsearchIndexSchemaFieldNode node = this.fieldOrNullIgnoringInclusion(absolutePath);
        return node == null ? null : (AbstractElasticsearchIndexSchemaFieldNode)filter.filter((Object)node, node.inclusion());
    }

    public Collection<IndexFieldDescriptor> staticFields() {
        return this.includedStaticFields;
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    public void contributeLowLevelMetadata(LowLevelIndexMetadataBuilder builder) {
        builder.setAnalysisDefinitionRegistry(this.analysisDefinitionRegistry);
        builder.setMapping(this.mapping);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "names=" + this.names + ", mapping=" + this.mapping + "]";
    }

    private AbstractElasticsearchIndexSchemaFieldNode fieldOrNullIgnoringInclusion(String absolutePath) {
        AbstractElasticsearchIndexSchemaFieldNode field = this.staticFields.get(absolutePath);
        if (field != null) {
            return field;
        }
        field = (AbstractElasticsearchIndexSchemaFieldNode)this.dynamicFieldsCache.get(absolutePath);
        if (field != null) {
            return field;
        }
        for (AbstractElasticsearchIndexSchemaFieldTemplate<?> template : this.fieldTemplates) {
            field = template.createNodeIfMatching(this, absolutePath);
            if (field == null) continue;
            AbstractElasticsearchIndexSchemaFieldNode previous = this.dynamicFieldsCache.putIfAbsent(absolutePath, field);
            if (previous == null) break;
            field = previous;
            break;
        }
        return field;
    }

    @Override
    public String readName() {
        return this.names.read().toString();
    }

    @Override
    public String writeName() {
        return this.names.write().toString();
    }
}

