/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.impl;

import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.search.impl.SearchQueryElementTypeKey;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughFromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;

public class ElasticsearchIndexValueFieldType<F>
implements IndexValueFieldTypeDescriptor,
IndexFieldType<F>,
ElasticsearchSearchValueFieldTypeContext<F> {
    private final Class<F> valueType;
    private final JsonPrimitive elasticsearchTypeAsJson;
    private final DslConverter<F, F> rawDslConverter;
    private final ProjectionConverter<F, F> rawProjectionConverter;
    private final ElasticsearchFieldCodec<F> codec;
    private final DslConverter<?, F> dslConverter;
    private final ProjectionConverter<F, ?> projectionConverter;
    private final boolean searchable;
    private final boolean sortable;
    private final boolean projectable;
    private final boolean aggregable;
    private final Map<SearchQueryElementTypeKey<?>, ElasticsearchSearchValueFieldQueryElementFactory<?, F>> queryElementFactories;
    private final String analyzerName;
    private final String searchAnalyzerName;
    private final String normalizerName;
    private final PropertyMapping mapping;

    public ElasticsearchIndexValueFieldType(Builder<F> builder) {
        this.valueType = ((Builder)builder).valueType;
        this.elasticsearchTypeAsJson = ((Builder)builder).elasticsearchTypeAsJson();
        this.rawDslConverter = ((Builder)builder).rawDslConverter;
        this.rawProjectionConverter = ((Builder)builder).rawProjectionConverter;
        this.codec = ((Builder)builder).codec;
        this.dslConverter = ((Builder)builder).dslConverter != null ? ((Builder)builder).dslConverter : this.rawDslConverter;
        this.projectionConverter = ((Builder)builder).projectionConverter != null ? ((Builder)builder).projectionConverter : this.rawProjectionConverter;
        this.searchable = ((Builder)builder).searchable;
        this.sortable = ((Builder)builder).sortable;
        this.projectable = ((Builder)builder).projectable;
        this.aggregable = ((Builder)builder).aggregable;
        this.queryElementFactories = ((Builder)builder).queryElementFactories;
        this.analyzerName = ((Builder)builder).analyzerName;
        this.searchAnalyzerName = ((Builder)builder).searchAnalyzerName != null ? ((Builder)builder).searchAnalyzerName : ((Builder)builder).analyzerName;
        this.normalizerName = ((Builder)builder).normalizerName;
        this.mapping = ((Builder)builder).mapping;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[mapping=" + this.mapping.toString() + ", capabilities=" + this.queryElementFactories.keySet() + "]";
    }

    public Class<F> valueClass() {
        return this.valueType;
    }

    @Override
    public JsonPrimitive elasticsearchTypeAsJson() {
        return this.elasticsearchTypeAsJson;
    }

    public ElasticsearchFieldCodec<F> codec() {
        return this.codec;
    }

    public boolean searchable() {
        return this.searchable;
    }

    public boolean sortable() {
        return this.sortable;
    }

    public boolean projectable() {
        return this.projectable;
    }

    public boolean aggregable() {
        return this.aggregable;
    }

    public Class<?> dslArgumentClass() {
        return this.dslConverter.valueType();
    }

    @Override
    public DslConverter<?, F> dslConverter() {
        return this.dslConverter;
    }

    @Override
    public DslConverter<F, F> rawDslConverter() {
        return this.rawDslConverter;
    }

    public Class<?> projectedValueClass() {
        return this.projectionConverter.valueType();
    }

    @Override
    public ProjectionConverter<F, ?> projectionConverter() {
        return this.projectionConverter;
    }

    @Override
    public ProjectionConverter<F, F> rawProjectionConverter() {
        return this.rawProjectionConverter;
    }

    public Optional<String> analyzerName() {
        return Optional.ofNullable(this.analyzerName);
    }

    @Override
    public Optional<String> normalizerName() {
        return Optional.ofNullable(this.normalizerName);
    }

    @Override
    public boolean hasNormalizerOnAtLeastOneIndex() {
        return this.normalizerName().isPresent();
    }

    @Override
    public Optional<String> searchAnalyzerName() {
        return Optional.ofNullable(this.searchAnalyzerName);
    }

    @Override
    public <T> ElasticsearchSearchValueFieldQueryElementFactory<T, F> queryElementFactory(SearchQueryElementTypeKey<T> key) {
        return this.queryElementFactories.get(key);
    }

    public PropertyMapping mapping() {
        return this.mapping;
    }

    public static class Builder<F> {
        private final Class<F> valueType;
        private final DslConverter<F, F> rawDslConverter;
        private final ProjectionConverter<F, F> rawProjectionConverter;
        private ElasticsearchFieldCodec<F> codec;
        private DslConverter<?, F> dslConverter;
        private ProjectionConverter<F, ?> projectionConverter;
        private boolean searchable;
        private boolean sortable;
        private boolean projectable;
        private boolean aggregable;
        private final Map<SearchQueryElementTypeKey<?>, ElasticsearchSearchValueFieldQueryElementFactory<?, F>> queryElementFactories = new HashMap();
        private String analyzerName;
        private String searchAnalyzerName;
        private String normalizerName;
        private final PropertyMapping mapping;

        public Builder(Class<F> valueType, PropertyMapping mapping) {
            this.valueType = valueType;
            this.rawDslConverter = new DslConverter(valueType, (ToDocumentFieldValueConverter)new PassThroughToDocumentFieldValueConverter());
            this.rawProjectionConverter = new ProjectionConverter(valueType, (FromDocumentFieldValueConverter)new PassThroughFromDocumentFieldValueConverter());
            this.mapping = mapping;
        }

        public Class<F> valueType() {
            return this.valueType;
        }

        public void codec(ElasticsearchFieldCodec<F> codec) {
            this.codec = codec;
        }

        public ElasticsearchFieldCodec<F> codec() {
            return this.codec;
        }

        public <V> void dslConverter(Class<V> valueType, ToDocumentFieldValueConverter<V, ? extends F> toIndexConverter) {
            this.dslConverter = new DslConverter(valueType, toIndexConverter);
        }

        public <V> void projectionConverter(Class<V> valueType, FromDocumentFieldValueConverter<? super F, V> fromIndexConverter) {
            this.projectionConverter = new ProjectionConverter(valueType, fromIndexConverter);
        }

        public void searchable(boolean searchable) {
            this.searchable = searchable;
        }

        public void sortable(boolean sortable) {
            this.sortable = sortable;
        }

        public void projectable(boolean projectable) {
            this.projectable = projectable;
        }

        public void aggregable(boolean aggregable) {
            this.aggregable = aggregable;
        }

        public <T> void queryElementFactory(SearchQueryElementTypeKey<T> key, ElasticsearchSearchValueFieldQueryElementFactory<T, F> factory) {
            this.queryElementFactories.put(key, factory);
        }

        public void analyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
        }

        public void searchAnalyzerName(String searchAnalyzerName) {
            this.searchAnalyzerName = searchAnalyzerName;
        }

        public void normalizerName(String normalizerName) {
            this.normalizerName = normalizerName;
        }

        public PropertyMapping mapping() {
            return this.mapping;
        }

        public ElasticsearchIndexValueFieldType<F> build() {
            return new ElasticsearchIndexValueFieldType(this);
        }

        private JsonPrimitive elasticsearchTypeAsJson() {
            String typeName = this.mapping.getType();
            if (typeName == null) {
                typeName = "object";
            }
            return new JsonPrimitive(typeName);
        }
    }
}

