/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.DeleteWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.IndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexIndexingPlanExecution;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;

public class ElasticsearchIndexIndexingPlan<R>
implements IndexIndexingPlan<R> {
    private final ElasticsearchWorkBuilderFactory builderFactory;
    private final ElasticsearchSerialWorkOrchestrator orchestrator;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;
    private final EntityReferenceFactory<R> entityReferenceFactory;
    private final DocumentRefreshStrategy refreshStrategy;
    private final List<SingleDocumentIndexingWork> works = new ArrayList<SingleDocumentIndexingWork>();

    public ElasticsearchIndexIndexingPlan(ElasticsearchWorkBuilderFactory builderFactory, ElasticsearchSerialWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext, EntityReferenceFactory<R> entityReferenceFactory, DocumentRefreshStrategy refreshStrategy) {
        this.builderFactory = builderFactory;
        this.orchestrator = orchestrator;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.tenantIdentifier();
        this.entityReferenceFactory = entityReferenceFactory;
        this.refreshStrategy = refreshStrategy;
    }

    public void add(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        this.index(referenceProvider, documentContributor);
    }

    public void addOrUpdate(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        this.index(referenceProvider, documentContributor);
    }

    public void delete(DocumentReferenceProvider referenceProvider) {
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, referenceProvider.identifier());
        String routingKey = referenceProvider.routingKey();
        this.collect((SingleDocumentIndexingWork)((DeleteWorkBuilder)this.builderFactory.delete(this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), this.indexManagerContext.getElasticsearchIndexWriteName(), elasticsearchId, routingKey).refresh(this.refreshStrategy)).build());
    }

    public CompletableFuture<IndexIndexingPlanExecutionReport<R>> executeAndReport() {
        try {
            ElasticsearchIndexIndexingPlanExecution<R> execution = new ElasticsearchIndexIndexingPlanExecution<R>(this.orchestrator, this.entityReferenceFactory, new ArrayList<SingleDocumentIndexingWork>(this.works));
            CompletableFuture<IndexIndexingPlanExecutionReport<R>> completableFuture = execution.execute();
            return completableFuture;
        }
        finally {
            this.works.clear();
        }
    }

    public void discard() {
        this.works.clear();
    }

    private void index(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        String id = referenceProvider.identifier();
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.routingKey();
        JsonObject document = this.indexManagerContext.createDocument(this.tenantId, id, documentContributor);
        this.collect((SingleDocumentIndexingWork)((IndexWorkBuilder)this.builderFactory.index(this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), this.indexManagerContext.getElasticsearchIndexWriteName(), elasticsearchId, routingKey, document).refresh(this.refreshStrategy)).build());
    }

    private void collect(SingleDocumentIndexingWork work) {
        this.works.add(work);
    }
}

