/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.scope.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDifferentNestedObjectCompatibilityChecker {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSearchIndexesContext indexes;
    private final String fieldPath;
    private final List<String> nestedPathHierarchy;

    public static ElasticsearchDifferentNestedObjectCompatibilityChecker empty(ElasticsearchSearchIndexesContext indexes) {
        return new ElasticsearchDifferentNestedObjectCompatibilityChecker(indexes, null, Collections.emptyList());
    }

    private ElasticsearchDifferentNestedObjectCompatibilityChecker(ElasticsearchSearchIndexesContext indexes, String fieldPath, List<String> nestedPathHierarchy) {
        this.indexes = indexes;
        this.fieldPath = fieldPath;
        this.nestedPathHierarchy = nestedPathHierarchy;
    }

    public ElasticsearchDifferentNestedObjectCompatibilityChecker combineAndCheck(String incomingFieldPath) {
        List<String> incomingNestedPathHierarchy = this.indexes.field(incomingFieldPath).nestedPathHierarchy();
        if (this.fieldPath == null) {
            return new ElasticsearchDifferentNestedObjectCompatibilityChecker(this.indexes, incomingFieldPath, incomingNestedPathHierarchy);
        }
        if (!this.nestedPathHierarchy.equals(incomingNestedPathHierarchy)) {
            throw log.simpleQueryStringSpanningMultipleNestedPaths(this.fieldPath, ElasticsearchDifferentNestedObjectCompatibilityChecker.getLastPath(this.nestedPathHierarchy), incomingFieldPath, ElasticsearchDifferentNestedObjectCompatibilityChecker.getLastPath(incomingNestedPathHierarchy));
        }
        return this;
    }

    public List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    private static String getLastPath(List<String> hierarchy) {
        if (hierarchy.isEmpty()) {
            return "<<root>>";
        }
        return hierarchy.get(hierarchy.size() - 1);
    }
}

