/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.Gson;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.lowlevel.impl.LowLevelIndexMetadataBuilder;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.mapping.impl.TypeNameMapping;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchBatchingWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.resources.impl.BackendThreads;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexSchemaManager;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexIndexer;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexIndexingPlan;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexWorkspace;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionBackendContext;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexManagerBackendContext
implements SearchBackendContext,
WorkExecutionBackendContext {
    private final ElasticsearchBackend backendAPI;
    private final EventContext eventContext;
    private final BackendThreads threads;
    private final ElasticsearchLink link;
    private final Gson userFacingGson;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final IndexLayoutStrategy indexLayoutStrategy;
    private final FailureHandler failureHandler;
    private final TimingSource timingSource;
    private final ElasticsearchParallelWorkOrchestrator generalPurposeOrchestrator;
    private final SearchProjectionBackendContext searchProjectionBackendContext;

    public IndexManagerBackendContext(ElasticsearchBackend backendAPI, EventContext eventContext, BackendThreads threads, ElasticsearchLink link, Gson userFacingGson, MultiTenancyStrategy multiTenancyStrategy, IndexLayoutStrategy indexLayoutStrategy, TypeNameMapping typeNameMapping, FailureHandler failureHandler, TimingSource timingSource, ElasticsearchParallelWorkOrchestrator generalPurposeOrchestrator) {
        this.backendAPI = backendAPI;
        this.eventContext = eventContext;
        this.threads = threads;
        this.link = link;
        this.userFacingGson = userFacingGson;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.indexLayoutStrategy = indexLayoutStrategy;
        this.failureHandler = failureHandler;
        this.timingSource = timingSource;
        this.generalPurposeOrchestrator = generalPurposeOrchestrator;
        this.searchProjectionBackendContext = new SearchProjectionBackendContext(typeNameMapping.getTypeNameExtractionHelper(), multiTenancyStrategy.idProjectionExtractionHelper());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    @Override
    public <R> IndexIndexingPlan<R> createIndexingPlan(ElasticsearchSerialWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext, EntityReferenceFactory<R> entityReferenceFactory, DocumentRefreshStrategy refreshStrategy) {
        this.multiTenancyStrategy.documentIdHelper().checkTenantId(sessionContext.tenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexIndexingPlan<R>(this.link.getWorkBuilderFactory(), orchestrator, indexManagerContext, sessionContext, entityReferenceFactory, refreshStrategy);
    }

    @Override
    public IndexIndexer createIndexer(ElasticsearchSerialWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext) {
        this.multiTenancyStrategy.documentIdHelper().checkTenantId(sessionContext.tenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexIndexer(this.link.getWorkBuilderFactory(), orchestrator, indexManagerContext, sessionContext);
    }

    @Override
    public IndexWorkspace createWorkspace(WorkExecutionIndexManagerContext indexManagerContext, DetachedBackendSessionContext sessionContext) {
        this.multiTenancyStrategy.documentIdHelper().checkTenantId(sessionContext.tenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexWorkspace(this.link.getWorkBuilderFactory(), this.multiTenancyStrategy, this.generalPurposeOrchestrator, indexManagerContext, sessionContext);
    }

    @Override
    public SearchProjectionBackendContext getSearchProjectionBackendContext() {
        return this.searchProjectionBackendContext;
    }

    @Override
    public ElasticsearchSearchContext createSearchContext(BackendMappingContext mappingContext, ElasticsearchSearchIndexesContext indexes) {
        return new ElasticsearchSearchContext(mappingContext, this.userFacingGson, this.link.getSearchSyntax(), this.multiTenancyStrategy, indexes, this.timingSource);
    }

    @Override
    public <H> ElasticsearchSearchQueryBuilder<H> createSearchQueryBuilder(ElasticsearchSearchContext searchContext, BackendSessionContext sessionContext, LoadingContextBuilder<?, ?, ?> loadingContextBuilder, ElasticsearchSearchProjection<?, H> rootProjection) {
        this.multiTenancyStrategy.documentIdHelper().checkTenantId(sessionContext.tenantIdentifier(), this.eventContext);
        return new ElasticsearchSearchQueryBuilder<H>(this.link.getWorkBuilderFactory(), this.link.getSearchResultExtractorFactory(), this.generalPurposeOrchestrator, searchContext, sessionContext, loadingContextBuilder, rootProjection, this.link.getScrollTimeout());
    }

    ElasticsearchBackend toAPI() {
        return this.backendAPI;
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    ElasticsearchIndexSchemaManager createSchemaManager(ElasticsearchIndexModel model, ElasticsearchIndexLifecycleExecutionOptions lifecycleExecutionOptions) {
        LowLevelIndexMetadataBuilder builder = new LowLevelIndexMetadataBuilder(this.link.getIndexMetadataSyntax(), model.names());
        model.contributeLowLevelMetadata(builder);
        IndexMetadata expectedMetadata = builder.build();
        return new ElasticsearchIndexSchemaManager(this.link.getWorkBuilderFactory(), this.generalPurposeOrchestrator, this.indexLayoutStrategy, model.names(), expectedMetadata, lifecycleExecutionOptions);
    }

    ElasticsearchBatchingWorkOrchestrator createIndexingOrchestrator(String indexName) {
        return new ElasticsearchBatchingWorkOrchestrator("Elasticsearch indexing orchestrator for index " + indexName, this.threads, this.link, this.failureHandler);
    }

    String toElasticsearchId(String tenantId, String id) {
        return this.multiTenancyStrategy.documentIdHelper().toElasticsearchId(tenantId, id);
    }
}

