/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.Elasticsearch60SearchSyntax;

public class Elasticsearch56SearchSyntax
extends Elasticsearch60SearchSyntax {
    private static final JsonAccessor<JsonElement> NESTED_PATH_ACCESSOR = JsonAccessor.root().property("nested_path");
    private static final JsonAccessor<JsonElement> NESTED_FILTER_ACCESSOR = JsonAccessor.root().property("nested_filter");

    @Override
    public String getTermAggregationOrderByTermToken() {
        return "_term";
    }

    @Override
    public void requestNestedSort(List<String> nestedPathHierarchy, JsonObject innerObject, JsonObject filterOrNull) {
        String lastNestedPath = nestedPathHierarchy.get(nestedPathHierarchy.size() - 1);
        NESTED_PATH_ACCESSOR.set(innerObject, (JsonElement)new JsonPrimitive(lastNestedPath));
        if (filterOrNull != null) {
            NESTED_FILTER_ACCESSOR.set(innerObject, (JsonElement)filterOrNull);
        }
    }
}

